package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface DockerBuildStrategyFluent<A extends DockerBuildStrategyFluent<A>> extends Fluent<A> {


    public A addToBuildArgs(int index,EnvVar item);
    public A setToBuildArgs(int index,EnvVar item);
    public A addToBuildArgs(EnvVar... items);
    public A addAllToBuildArgs(Collection<EnvVar> items);
    public A removeFromBuildArgs(EnvVar... items);
    public A removeAllFromBuildArgs(Collection<EnvVar> items);
    public List<EnvVar> getBuildArgs();
    public EnvVar getBuildArg(int index);
    public EnvVar getFirstBuildArg();
    public EnvVar getLastBuildArg();
    public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate);
    public Boolean hasMatchingBuildArg(Predicate<EnvVar> predicate);
    public A withBuildArgs(List<EnvVar> buildArgs);
    public A withBuildArgs(EnvVar... buildArgs);
    public Boolean hasBuildArgs();
    public String getDockerfilePath();
    public A withDockerfilePath(String dockerfilePath);
    public Boolean hasDockerfilePath();
    public A withNewDockerfilePath(String arg1);
    public A withNewDockerfilePath(StringBuilder arg1);
    public A withNewDockerfilePath(StringBuffer arg1);
    public A addToEnv(int index,EnvVar item);
    public A setToEnv(int index,EnvVar item);
    public A addToEnv(EnvVar... items);
    public A addAllToEnv(Collection<EnvVar> items);
    public A removeFromEnv(EnvVar... items);
    public A removeAllFromEnv(Collection<EnvVar> items);
    public List<EnvVar> getEnv();
    public EnvVar getEnv(int index);
    public EnvVar getFirstEnv();
    public EnvVar getLastEnv();
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate);
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate);
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public Boolean hasEnv();
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public Boolean hasForcePull();
    public A withNewForcePull(String arg1);
    public A withNewForcePull(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildFrom instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.ObjectReference getFrom();
    public io.fabric8.kubernetes.api.model.ObjectReference buildFrom();
    public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from);
    public Boolean hasFrom();
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom();
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public DockerBuildStrategyFluent.FromNested<A> editFrom();
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom();
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item);
    public String getImageOptimizationPolicy();
    public A withImageOptimizationPolicy(String imageOptimizationPolicy);
    public Boolean hasImageOptimizationPolicy();
    public A withNewImageOptimizationPolicy(String arg1);
    public A withNewImageOptimizationPolicy(StringBuilder arg1);
    public A withNewImageOptimizationPolicy(StringBuffer arg1);
    public Boolean isNoCache();
    public A withNoCache(Boolean noCache);
    public Boolean hasNoCache();
    public A withNewNoCache(String arg1);
    public A withNewNoCache(boolean arg1);
    
/**
 * This method has been deprecated, please use method buildPullSecret instead.
 * @return The buildable object.
 */
@Deprecated public LocalObjectReference getPullSecret();
    public LocalObjectReference buildPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public Boolean hasPullSecret();
    public A withNewPullSecret(String name);
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret();
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item);
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.fabric8.kubernetes.api.model.ObjectReferenceFluent<DockerBuildStrategyFluent.FromNested<N>> {

        public N and();
        public N endFrom();    }


    public interface PullSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LocalObjectReferenceFluent<DockerBuildStrategyFluent.PullSecretNested<N>> {

        public N and();
        public N endPullSecret();    }


}
