package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class ClusterNetworkFluentImpl<A extends ClusterNetworkFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterNetworkFluent<A> {

    private String apiVersion;
    private List<ClusterNetworkEntryBuilder> clusterNetworks =  new ArrayList<ClusterNetworkEntryBuilder>();
    private Integer hostsubnetlength;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer mtu;
    private String network;
    private String pluginName;
    private String serviceNetwork;
    private Integer vxlanPort;

    public ClusterNetworkFluentImpl() { 
    }


    public ClusterNetworkFluentImpl(ClusterNetwork instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withClusterNetworks(instance.getClusterNetworks()); 
        this.withHostsubnetlength(instance.getHostsubnetlength()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withMtu(instance.getMtu()); 
        this.withNetwork(instance.getNetwork()); 
        this.withPluginName(instance.getPluginName()); 
        this.withServiceNetwork(instance.getServiceNetwork()); 
        this.withVxlanPort(instance.getVxlanPort()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToClusterNetworks(int index,ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(index >= 0 ? index : _visitables.get("clusterNetworks").size(), builder);this.clusterNetworks.add(index >= 0 ? index : clusterNetworks.size(), builder); return (A)this;
    }

    public A setToClusterNetworks(int index,ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= _visitables.get("clusterNetworks").size()) { _visitables.get("clusterNetworks").add(builder); } else { _visitables.get("clusterNetworks").set(index, builder);}
        if (index < 0 || index >= clusterNetworks.size()) { clusterNetworks.add(builder); } else { clusterNetworks.set(index, builder);}
         return (A)this;
    }

    public A addToClusterNetworks(ClusterNetworkEntry... items) {
        if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
    }

    public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetworks == null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();}
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").add(builder);this.clusterNetworks.add(builder);} return (A)this;
    }

    public A removeFromClusterNetworks(ClusterNetworkEntry... items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder);if (this.clusterNetworks != null) {this.clusterNetworks.remove(builder);}} return (A)this;
    }

    public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);_visitables.get("clusterNetworks").remove(builder);if (this.clusterNetworks != null) {this.clusterNetworks.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (clusterNetworks == null) return (A) this;
        final Iterator<ClusterNetworkEntryBuilder> each = clusterNetworks.iterator();
        final List visitables = _visitables.get("clusterNetworks");
        while (each.hasNext()) {
          ClusterNetworkEntryBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildClusterNetworks instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterNetworkEntry> getClusterNetworks() {
        return build(clusterNetworks);
    }

    public List<ClusterNetworkEntry> buildClusterNetworks() {
        return build(clusterNetworks);
    }

    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetworks.get(index).build();
    }

    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetworks.get(0).build();
    }

    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetworks.get(clusterNetworks.size() - 1).build();
    }

    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item: clusterNetworks) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks) {
        if (this.clusterNetworks != null) { _visitables.get("clusterNetworks").removeAll(this.clusterNetworks);}
        if (clusterNetworks != null) {this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>(); for (ClusterNetworkEntry item : clusterNetworks){this.addToClusterNetworks(item);}} else { this.clusterNetworks = null;} return (A) this;
    }

    public A withClusterNetworks(ClusterNetworkEntry... clusterNetworks) {
        if (this.clusterNetworks != null) {this.clusterNetworks.clear();}
        if (clusterNetworks != null) {for (ClusterNetworkEntry item :clusterNetworks){ this.addToClusterNetworks(item);}} return (A) this;
    }

    public Boolean hasClusterNetworks() {
        return clusterNetworks != null && !clusterNetworks.isEmpty();
    }

    public A addNewClusterNetwork(String cidr,Integer hostSubnetLength) {
        return (A)addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork() {
        return new ClusterNetworksNestedImpl();
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(-1, item);
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(int index,ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(index, item);
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(int index) {
        if (clusterNetworks.size() <= index) throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork() {
        if (clusterNetworks.size() == 0) throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
        return setNewClusterNetworkLike(0, buildClusterNetwork(0));
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork() {
        int index = clusterNetworks.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i=0;i<clusterNetworks.size();i++) { 
        if (predicate.test(clusterNetworks.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
        return setNewClusterNetworkLike(index, buildClusterNetwork(index));
    }

    public Integer getHostsubnetlength() {
        return this.hostsubnetlength;
    }

    public A withHostsubnetlength(Integer hostsubnetlength) {
        this.hostsubnetlength=hostsubnetlength; return (A) this;
    }

    public Boolean hasHostsubnetlength() {
        return this.hostsubnetlength != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public ClusterNetworkFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public ClusterNetworkFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public Integer getMtu() {
        return this.mtu;
    }

    public A withMtu(Integer mtu) {
        this.mtu=mtu; return (A) this;
    }

    public Boolean hasMtu() {
        return this.mtu != null;
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network=network; return (A) this;
    }

    public Boolean hasNetwork() {
        return this.network != null;
    }

    public A withNewNetwork(String arg1) {
        return (A)withNetwork(new String(arg1));
    }

    public A withNewNetwork(StringBuilder arg1) {
        return (A)withNetwork(new String(arg1));
    }

    public A withNewNetwork(StringBuffer arg1) {
        return (A)withNetwork(new String(arg1));
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public A withPluginName(String pluginName) {
        this.pluginName=pluginName; return (A) this;
    }

    public Boolean hasPluginName() {
        return this.pluginName != null;
    }

    public A withNewPluginName(String arg1) {
        return (A)withPluginName(new String(arg1));
    }

    public A withNewPluginName(StringBuilder arg1) {
        return (A)withPluginName(new String(arg1));
    }

    public A withNewPluginName(StringBuffer arg1) {
        return (A)withPluginName(new String(arg1));
    }

    public String getServiceNetwork() {
        return this.serviceNetwork;
    }

    public A withServiceNetwork(String serviceNetwork) {
        this.serviceNetwork=serviceNetwork; return (A) this;
    }

    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null;
    }

    public A withNewServiceNetwork(String arg1) {
        return (A)withServiceNetwork(new String(arg1));
    }

    public A withNewServiceNetwork(StringBuilder arg1) {
        return (A)withServiceNetwork(new String(arg1));
    }

    public A withNewServiceNetwork(StringBuffer arg1) {
        return (A)withServiceNetwork(new String(arg1));
    }

    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    public A withVxlanPort(Integer vxlanPort) {
        this.vxlanPort=vxlanPort; return (A) this;
    }

    public Boolean hasVxlanPort() {
        return this.vxlanPort != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterNetworkFluentImpl that = (ClusterNetworkFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (clusterNetworks != null ? !clusterNetworks.equals(that.clusterNetworks) :that.clusterNetworks != null) return false;
        if (hostsubnetlength != null ? !hostsubnetlength.equals(that.hostsubnetlength) :that.hostsubnetlength != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (mtu != null ? !mtu.equals(that.mtu) :that.mtu != null) return false;
        if (network != null ? !network.equals(that.network) :that.network != null) return false;
        if (pluginName != null ? !pluginName.equals(that.pluginName) :that.pluginName != null) return false;
        if (serviceNetwork != null ? !serviceNetwork.equals(that.serviceNetwork) :that.serviceNetwork != null) return false;
        if (vxlanPort != null ? !vxlanPort.equals(that.vxlanPort) :that.vxlanPort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  clusterNetworks,  hostsubnetlength,  kind,  metadata,  mtu,  network,  pluginName,  serviceNetwork,  vxlanPort,  super.hashCode());
    }

    public class ClusterNetworksNestedImpl<N> extends ClusterNetworkEntryFluentImpl<ClusterNetworkFluent.ClusterNetworksNested<N>> implements ClusterNetworkFluent.ClusterNetworksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        ClusterNetworksNestedImpl(int index,ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworksNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        public N and() {
             return (N) ClusterNetworkFluentImpl.this.setToClusterNetworks(index,builder.build());
        }

        public N endClusterNetwork() {
             return and();
        }
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ClusterNetworkFluent.MetadataNested<N>> implements ClusterNetworkFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        public N and() {
             return (N) ClusterNetworkFluentImpl.this.withMetadata(builder.build());
        }

        public N endMetadata() {
             return and();
        }
    }


}
