package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class SubjectRulesReviewSpecFluentImpl<A extends SubjectRulesReviewSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements SubjectRulesReviewSpecFluent<A> {

    private List<String> groups = new ArrayList<String>();
    private List<String> scopes = new ArrayList<String>();
    private String user;

    public SubjectRulesReviewSpecFluentImpl() { 
    }


    public SubjectRulesReviewSpecFluentImpl(SubjectRulesReviewSpec instance) { 
        this.withGroups(instance.getGroups()); 
        this.withScopes(instance.getScopes()); 
        this.withUser(instance.getUser()); 
    }


    public A addToGroups(int index,String item) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index,String item) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items) {
        for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(List<String> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public A addToScopes(int index,String item) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        this.scopes.add(index, item);
        return (A)this;
    }

    public A setToScopes(int index,String item) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        this.scopes.set(index, item); return (A)this;
    }

    public A addToScopes(String... items) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {this.scopes = new ArrayList<String>();}
        for (String item : items) {this.scopes.add(item);} return (A)this;
    }

    public A removeFromScopes(String... items) {
        for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {if (this.scopes!= null){ this.scopes.remove(item);}} return (A)this;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public String getScope(int index) {
        return this.scopes.get(index);
    }

    public String getFirstScope() {
        return this.scopes.get(0);
    }

    public String getLastScope() {
        return this.scopes.get(scopes.size() - 1);
    }

    public String getMatchingScope(Predicate<String> predicate) {
        for (String item: scopes) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item: scopes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withScopes(List<String> scopes) {
        if (this.scopes != null) { _visitables.get("scopes").removeAll(this.scopes);}
        if (scopes != null) {this.scopes = new ArrayList<String>(); for (String item : scopes){this.addToScopes(item);}} else { this.scopes = null;} return (A) this;
    }

    public A withScopes(String... scopes) {
        if (this.scopes != null) {this.scopes.clear();}
        if (scopes != null) {for (String item :scopes){ this.addToScopes(item);}} return (A) this;
    }

    public Boolean hasScopes() {
        return scopes != null && !scopes.isEmpty();
    }

    public A addNewScope(String arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(StringBuilder arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public A addNewScope(StringBuffer arg1) {
        return (A)addToScopes(new String(arg1));
    }

    public String getUser() {
        return this.user;
    }

    public A withUser(String user) {
        this.user=user; return (A) this;
    }

    public Boolean hasUser() {
        return this.user != null;
    }

    public A withNewUser(String arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuilder arg1) {
        return (A)withUser(new String(arg1));
    }

    public A withNewUser(StringBuffer arg1) {
        return (A)withUser(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SubjectRulesReviewSpecFluentImpl that = (SubjectRulesReviewSpecFluentImpl) o;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        if (scopes != null ? !scopes.equals(that.scopes) :that.scopes != null) return false;
        if (user != null ? !user.equals(that.user) :that.user != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(groups,  scopes,  user,  super.hashCode());
    }

}
