package io.fabric8.openshift.api.model;

import java.lang.String;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.lang.Deprecated;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ResourceAccessReviewFluent<A extends ResourceAccessReviewFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildContent instead.
 * @return The buildable object.
 */
@Deprecated public HasMetadata getContent();
    public HasMetadata buildContent();
    public A withContent(HasMetadata content);
    public Boolean hasContent();
    public A withClusterVersionContent(ClusterVersion clusterVersionContent);
    public ResourceAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContent();
    public ResourceAccessReviewFluent.ClusterVersionContentNested<A> withNewClusterVersionContentLike(ClusterVersion item);
    public A withImageStreamImportContent(ImageStreamImport imageStreamImportContent);
    public ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContent();
    public ResourceAccessReviewFluent.ImageStreamImportContentNested<A> withNewImageStreamImportContentLike(ImageStreamImport item);
    public A withProxyContent(Proxy proxyContent);
    public ResourceAccessReviewFluent.ProxyContentNested<A> withNewProxyContent();
    public ResourceAccessReviewFluent.ProxyContentNested<A> withNewProxyContentLike(Proxy item);
    public A withProjectContent(Project projectContent);
    public ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContent();
    public ResourceAccessReviewFluent.ProjectContentNested<A> withNewProjectContentLike(Project item);
    public A withClusterOperatorContent(ClusterOperator clusterOperatorContent);
    public ResourceAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContent();
    public ResourceAccessReviewFluent.ClusterOperatorContentNested<A> withNewClusterOperatorContentLike(ClusterOperator item);
    public A withBuildConfigContent(BuildConfig buildConfigContent);
    public ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContent();
    public ResourceAccessReviewFluent.BuildConfigContentNested<A> withNewBuildConfigContentLike(BuildConfig item);
    public A withInfrastructureContent(Infrastructure infrastructureContent);
    public ResourceAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContent();
    public ResourceAccessReviewFluent.InfrastructureContentNested<A> withNewInfrastructureContentLike(Infrastructure item);
    public A withSchedulerContent(Scheduler schedulerContent);
    public ResourceAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContent();
    public ResourceAccessReviewFluent.SchedulerContentNested<A> withNewSchedulerContentLike(Scheduler item);
    public A withRangeAllocationContent(RangeAllocation rangeAllocationContent);
    public ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContent();
    public ResourceAccessReviewFluent.RangeAllocationContentNested<A> withNewRangeAllocationContentLike(RangeAllocation item);
    public A withRouteContent(Route routeContent);
    public ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContent();
    public ResourceAccessReviewFluent.RouteContentNested<A> withNewRouteContentLike(Route item);
    public A withClusterNetworkContent(ClusterNetwork clusterNetworkContent);
    public ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContent();
    public ResourceAccessReviewFluent.ClusterNetworkContentNested<A> withNewClusterNetworkContentLike(ClusterNetwork item);
    public A withOAuthAuthorizeTokenContent(OAuthAuthorizeToken oAuthAuthorizeTokenContent);
    public ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContent();
    public ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<A> withNewOAuthAuthorizeTokenContentLike(OAuthAuthorizeToken item);
    public A withOAuthContent(OAuth oAuthContent);
    public ResourceAccessReviewFluent.OAuthContentNested<A> withNewOAuthContent();
    public ResourceAccessReviewFluent.OAuthContentNested<A> withNewOAuthContentLike(OAuth item);
    public A withOperatorHubContent(OperatorHub operatorHubContent);
    public ResourceAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContent();
    public ResourceAccessReviewFluent.OperatorHubContentNested<A> withNewOperatorHubContentLike(OperatorHub item);
    public A withClusterRoleBindingContent(ClusterRoleBinding clusterRoleBindingContent);
    public ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContent();
    public ResourceAccessReviewFluent.ClusterRoleBindingContentNested<A> withNewClusterRoleBindingContentLike(ClusterRoleBinding item);
    public A withClusterResourceQuotaContent(ClusterResourceQuota clusterResourceQuotaContent);
    public ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContent();
    public ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<A> withNewClusterResourceQuotaContentLike(ClusterResourceQuota item);
    public A withProjectRequestContent(ProjectRequest projectRequestContent);
    public ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContent();
    public ResourceAccessReviewFluent.ProjectRequestContentNested<A> withNewProjectRequestContentLike(ProjectRequest item);
    public A withTemplateContent(Template templateContent);
    public ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContent();
    public ResourceAccessReviewFluent.TemplateContentNested<A> withNewTemplateContentLike(Template item);
    public A withOAuthClientAuthorizationContent(OAuthClientAuthorization oAuthClientAuthorizationContent);
    public ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContent();
    public ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<A> withNewOAuthClientAuthorizationContentLike(OAuthClientAuthorization item);
    public A withClusterRoleContent(ClusterRole clusterRoleContent);
    public ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContent();
    public ResourceAccessReviewFluent.ClusterRoleContentNested<A> withNewClusterRoleContentLike(ClusterRole item);
    public A withImageTagContent(ImageTag imageTagContent);
    public ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContent();
    public ResourceAccessReviewFluent.ImageTagContentNested<A> withNewImageTagContentLike(ImageTag item);
    public A withDeploymentConfigContent(DeploymentConfig deploymentConfigContent);
    public ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContent();
    public ResourceAccessReviewFluent.DeploymentConfigContentNested<A> withNewDeploymentConfigContentLike(DeploymentConfig item);
    public A withOAuthAccessTokenContent(OAuthAccessToken oAuthAccessTokenContent);
    public ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContent();
    public ResourceAccessReviewFluent.OAuthAccessTokenContentNested<A> withNewOAuthAccessTokenContentLike(OAuthAccessToken item);
    public A withRoleBindingContent(RoleBinding roleBindingContent);
    public ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContent();
    public ResourceAccessReviewFluent.RoleBindingContentNested<A> withNewRoleBindingContentLike(RoleBinding item);
    public A withImageContent(Image imageContent);
    public ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContent();
    public ResourceAccessReviewFluent.ImageContentNested<A> withNewImageContentLike(Image item);
    public A withAPIServerContent(APIServer aPIServerContent);
    public ResourceAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContent();
    public ResourceAccessReviewFluent.APIServerContentNested<A> withNewAPIServerContentLike(APIServer item);
    public A withPersistentVolumeClaimContent(PersistentVolumeClaim persistentVolumeClaimContent);
    public ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContent();
    public ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<A> withNewPersistentVolumeClaimContentLike(PersistentVolumeClaim item);
    public A withImageStreamMappingContent(ImageStreamMapping imageStreamMappingContent);
    public ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContent();
    public ResourceAccessReviewFluent.ImageStreamMappingContentNested<A> withNewImageStreamMappingContentLike(ImageStreamMapping item);
    public A withRoleContent(Role roleContent);
    public ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContent();
    public ResourceAccessReviewFluent.RoleContentNested<A> withNewRoleContentLike(Role item);
    public A withFeatureGateContent(FeatureGate featureGateContent);
    public ResourceAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContent();
    public ResourceAccessReviewFluent.FeatureGateContentNested<A> withNewFeatureGateContentLike(FeatureGate item);
    public A withUserContent(User userContent);
    public ResourceAccessReviewFluent.UserContentNested<A> withNewUserContent();
    public ResourceAccessReviewFluent.UserContentNested<A> withNewUserContentLike(User item);
    public A withImageStreamImageContent(ImageStreamImage imageStreamImageContent);
    public ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContent();
    public ResourceAccessReviewFluent.ImageStreamImageContentNested<A> withNewImageStreamImageContentLike(ImageStreamImage item);
    public A withBuildContent(Build buildContent);
    public ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContent();
    public ResourceAccessReviewFluent.BuildContentNested<A> withNewBuildContentLike(Build item);
    public A withRoleBindingRestrictionContent(RoleBindingRestriction roleBindingRestrictionContent);
    public ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContent();
    public ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<A> withNewRoleBindingRestrictionContentLike(RoleBindingRestriction item);
    public A withImageStreamTagContent(ImageStreamTag imageStreamTagContent);
    public ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContent();
    public ResourceAccessReviewFluent.ImageStreamTagContentNested<A> withNewImageStreamTagContentLike(ImageStreamTag item);
    public A withGroupContent(io.fabric8.openshift.api.model.Group groupContent);
    public ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContent();
    public ResourceAccessReviewFluent.GroupContentNested<A> withNewGroupContentLike(io.fabric8.openshift.api.model.Group item);
    public A withImageSignatureContent(ImageSignature imageSignatureContent);
    public ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContent();
    public ResourceAccessReviewFluent.ImageSignatureContentNested<A> withNewImageSignatureContentLike(ImageSignature item);
    public A withAppliedClusterResourceQuotaContent(AppliedClusterResourceQuota appliedClusterResourceQuotaContent);
    public ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContent();
    public ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<A> withNewAppliedClusterResourceQuotaContentLike(AppliedClusterResourceQuota item);
    public A withSecurityContextConstraintsContent(SecurityContextConstraints securityContextConstraintsContent);
    public ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContent();
    public ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<A> withNewSecurityContextConstraintsContentLike(SecurityContextConstraints item);
    public A withBuildRequestContent(BuildRequest buildRequestContent);
    public ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContent();
    public ResourceAccessReviewFluent.BuildRequestContentNested<A> withNewBuildRequestContentLike(BuildRequest item);
    public A withEgressNetworkPolicyContent(EgressNetworkPolicy egressNetworkPolicyContent);
    public ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContent();
    public ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<A> withNewEgressNetworkPolicyContentLike(EgressNetworkPolicy item);
    public A withNetNamespaceContent(NetNamespace netNamespaceContent);
    public ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContent();
    public ResourceAccessReviewFluent.NetNamespaceContentNested<A> withNewNetNamespaceContentLike(NetNamespace item);
    public A withImageStreamContent(ImageStream imageStreamContent);
    public ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContent();
    public ResourceAccessReviewFluent.ImageStreamContentNested<A> withNewImageStreamContentLike(ImageStream item);
    public A withOAuthClientContent(OAuthClient oAuthClientContent);
    public ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContent();
    public ResourceAccessReviewFluent.OAuthClientContentNested<A> withNewOAuthClientContentLike(OAuthClient item);
    public A withIdentityContent(Identity identityContent);
    public ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContent();
    public ResourceAccessReviewFluent.IdentityContentNested<A> withNewIdentityContentLike(Identity item);
    public Boolean isIsNonResourceURL();
    public A withIsNonResourceURL(Boolean isNonResourceURL);
    public Boolean hasIsNonResourceURL();
    public A withNewIsNonResourceURL(String arg1);
    public A withNewIsNonResourceURL(boolean arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public String getNamespace();
    public A withNamespace(String namespace);
    public Boolean hasNamespace();
    public A withNewNamespace(String arg1);
    public A withNewNamespace(StringBuilder arg1);
    public A withNewNamespace(StringBuffer arg1);
    public String getPath();
    public A withPath(String path);
    public Boolean hasPath();
    public A withNewPath(String arg1);
    public A withNewPath(StringBuilder arg1);
    public A withNewPath(StringBuffer arg1);
    public String getResource();
    public A withResource(String resource);
    public Boolean hasResource();
    public A withNewResource(String arg1);
    public A withNewResource(StringBuilder arg1);
    public A withNewResource(StringBuffer arg1);
    public String getResourceAPIGroup();
    public A withResourceAPIGroup(String resourceAPIGroup);
    public Boolean hasResourceAPIGroup();
    public A withNewResourceAPIGroup(String arg1);
    public A withNewResourceAPIGroup(StringBuilder arg1);
    public A withNewResourceAPIGroup(StringBuffer arg1);
    public String getResourceAPIVersion();
    public A withResourceAPIVersion(String resourceAPIVersion);
    public Boolean hasResourceAPIVersion();
    public A withNewResourceAPIVersion(String arg1);
    public A withNewResourceAPIVersion(StringBuilder arg1);
    public A withNewResourceAPIVersion(StringBuffer arg1);
    public String getResourceName();
    public A withResourceName(String resourceName);
    public Boolean hasResourceName();
    public A withNewResourceName(String arg1);
    public A withNewResourceName(StringBuilder arg1);
    public A withNewResourceName(StringBuffer arg1);
    public String getVerb();
    public A withVerb(String verb);
    public Boolean hasVerb();
    public A withNewVerb(String arg1);
    public A withNewVerb(StringBuilder arg1);
    public A withNewVerb(StringBuffer arg1);
    public interface ClusterVersionContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterVersionFluent<ResourceAccessReviewFluent.ClusterVersionContentNested<N>> {

        public N and();
        public N endClusterVersionContent();    }


    public interface ImageStreamImportContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImportFluent<ResourceAccessReviewFluent.ImageStreamImportContentNested<N>> {

        public N and();
        public N endImageStreamImportContent();    }


    public interface ProxyContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProxyFluent<ResourceAccessReviewFluent.ProxyContentNested<N>> {

        public N and();
        public N endProxyContent();    }


    public interface ProjectContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectFluent<ResourceAccessReviewFluent.ProjectContentNested<N>> {

        public N and();
        public N endProjectContent();    }


    public interface ClusterOperatorContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorFluent<ResourceAccessReviewFluent.ClusterOperatorContentNested<N>> {

        public N and();
        public N endClusterOperatorContent();    }


    public interface BuildConfigContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildConfigFluent<ResourceAccessReviewFluent.BuildConfigContentNested<N>> {

        public N and();
        public N endBuildConfigContent();    }


    public interface InfrastructureContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InfrastructureFluent<ResourceAccessReviewFluent.InfrastructureContentNested<N>> {

        public N and();
        public N endInfrastructureContent();    }


    public interface SchedulerContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SchedulerFluent<ResourceAccessReviewFluent.SchedulerContentNested<N>> {

        public N and();
        public N endSchedulerContent();    }


    public interface RangeAllocationContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RangeAllocationFluent<ResourceAccessReviewFluent.RangeAllocationContentNested<N>> {

        public N and();
        public N endRangeAllocationContent();    }


    public interface RouteContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RouteFluent<ResourceAccessReviewFluent.RouteContentNested<N>> {

        public N and();
        public N endRouteContent();    }


    public interface ClusterNetworkContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterNetworkFluent<ResourceAccessReviewFluent.ClusterNetworkContentNested<N>> {

        public N and();
        public N endClusterNetworkContent();    }


    public interface OAuthAuthorizeTokenContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAuthorizeTokenFluent<ResourceAccessReviewFluent.OAuthAuthorizeTokenContentNested<N>> {

        public N and();
        public N endOAuthAuthorizeTokenContent();    }


    public interface OAuthContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthFluent<ResourceAccessReviewFluent.OAuthContentNested<N>> {

        public N and();
        public N endOAuthContent();    }


    public interface OperatorHubContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OperatorHubFluent<ResourceAccessReviewFluent.OperatorHubContentNested<N>> {

        public N and();
        public N endOperatorHubContent();    }


    public interface ClusterRoleBindingContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleBindingFluent<ResourceAccessReviewFluent.ClusterRoleBindingContentNested<N>> {

        public N and();
        public N endClusterRoleBindingContent();    }


    public interface ClusterResourceQuotaContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterResourceQuotaFluent<ResourceAccessReviewFluent.ClusterResourceQuotaContentNested<N>> {

        public N and();
        public N endClusterResourceQuotaContent();    }


    public interface ProjectRequestContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProjectRequestFluent<ResourceAccessReviewFluent.ProjectRequestContentNested<N>> {

        public N and();
        public N endProjectRequestContent();    }


    public interface TemplateContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TemplateFluent<ResourceAccessReviewFluent.TemplateContentNested<N>> {

        public N and();
        public N endTemplateContent();    }


    public interface OAuthClientAuthorizationContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientAuthorizationFluent<ResourceAccessReviewFluent.OAuthClientAuthorizationContentNested<N>> {

        public N and();
        public N endOAuthClientAuthorizationContent();    }


    public interface ClusterRoleContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterRoleFluent<ResourceAccessReviewFluent.ClusterRoleContentNested<N>> {

        public N and();
        public N endClusterRoleContent();    }


    public interface ImageTagContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageTagFluent<ResourceAccessReviewFluent.ImageTagContentNested<N>> {

        public N and();
        public N endImageTagContent();    }


    public interface DeploymentConfigContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeploymentConfigFluent<ResourceAccessReviewFluent.DeploymentConfigContentNested<N>> {

        public N and();
        public N endDeploymentConfigContent();    }


    public interface OAuthAccessTokenContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthAccessTokenFluent<ResourceAccessReviewFluent.OAuthAccessTokenContentNested<N>> {

        public N and();
        public N endOAuthAccessTokenContent();    }


    public interface RoleBindingContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingFluent<ResourceAccessReviewFluent.RoleBindingContentNested<N>> {

        public N and();
        public N endRoleBindingContent();    }


    public interface ImageContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageFluent<ResourceAccessReviewFluent.ImageContentNested<N>> {

        public N and();
        public N endImageContent();    }


    public interface APIServerContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIServerFluent<ResourceAccessReviewFluent.APIServerContentNested<N>> {

        public N and();
        public N endAPIServerContent();    }


    public interface PersistentVolumeClaimContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<ResourceAccessReviewFluent.PersistentVolumeClaimContentNested<N>> {

        public N and();
        public N endPersistentVolumeClaimContent();    }


    public interface ImageStreamMappingContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamMappingFluent<ResourceAccessReviewFluent.ImageStreamMappingContentNested<N>> {

        public N and();
        public N endImageStreamMappingContent();    }


    public interface RoleContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleFluent<ResourceAccessReviewFluent.RoleContentNested<N>> {

        public N and();
        public N endRoleContent();    }


    public interface FeatureGateContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FeatureGateFluent<ResourceAccessReviewFluent.FeatureGateContentNested<N>> {

        public N and();
        public N endFeatureGateContent();    }


    public interface UserContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,UserFluent<ResourceAccessReviewFluent.UserContentNested<N>> {

        public N and();
        public N endUserContent();    }


    public interface ImageStreamImageContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamImageFluent<ResourceAccessReviewFluent.ImageStreamImageContentNested<N>> {

        public N and();
        public N endImageStreamImageContent();    }


    public interface BuildContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildFluent<ResourceAccessReviewFluent.BuildContentNested<N>> {

        public N and();
        public N endBuildContent();    }


    public interface RoleBindingRestrictionContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RoleBindingRestrictionFluent<ResourceAccessReviewFluent.RoleBindingRestrictionContentNested<N>> {

        public N and();
        public N endRoleBindingRestrictionContent();    }


    public interface ImageStreamTagContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamTagFluent<ResourceAccessReviewFluent.ImageStreamTagContentNested<N>> {

        public N and();
        public N endImageStreamTagContent();    }


    public interface GroupContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GroupFluent<ResourceAccessReviewFluent.GroupContentNested<N>> {

        public N and();
        public N endGroupContent();    }


    public interface ImageSignatureContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ResourceAccessReviewFluent.ImageSignatureContentNested<N>> {

        public N and();
        public N endImageSignatureContent();    }


    public interface AppliedClusterResourceQuotaContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AppliedClusterResourceQuotaFluent<ResourceAccessReviewFluent.AppliedClusterResourceQuotaContentNested<N>> {

        public N and();
        public N endAppliedClusterResourceQuotaContent();    }


    public interface SecurityContextConstraintsContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecurityContextConstraintsFluent<ResourceAccessReviewFluent.SecurityContextConstraintsContentNested<N>> {

        public N and();
        public N endSecurityContextConstraintsContent();    }


    public interface BuildRequestContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildRequestFluent<ResourceAccessReviewFluent.BuildRequestContentNested<N>> {

        public N and();
        public N endBuildRequestContent();    }


    public interface EgressNetworkPolicyContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<ResourceAccessReviewFluent.EgressNetworkPolicyContentNested<N>> {

        public N and();
        public N endEgressNetworkPolicyContent();    }


    public interface NetNamespaceContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetNamespaceFluent<ResourceAccessReviewFluent.NetNamespaceContentNested<N>> {

        public N and();
        public N endNetNamespaceContent();    }


    public interface ImageStreamContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageStreamFluent<ResourceAccessReviewFluent.ImageStreamContentNested<N>> {

        public N and();
        public N endImageStreamContent();    }


    public interface OAuthClientContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,OAuthClientFluent<ResourceAccessReviewFluent.OAuthClientContentNested<N>> {

        public N and();
        public N endOAuthClientContent();    }


    public interface IdentityContentNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IdentityFluent<ResourceAccessReviewFluent.IdentityContentNested<N>> {

        public N and();
        public N endIdentityContent();    }


}
