package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.NamespaceCondition;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ProjectStatusFluentImpl<A extends ProjectStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ProjectStatusFluent<A> {

    private List<NamespaceCondition> conditions = new ArrayList<NamespaceCondition>();
    private String phase;

    public ProjectStatusFluentImpl() { 
    }


    public ProjectStatusFluentImpl(ProjectStatus instance) { 
        this.withConditions(instance.getConditions()); 
        this.withPhase(instance.getPhase()); 
    }


    public A addToConditions(int index,NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
        this.conditions.add(index, item);
        return (A)this;
    }

    public A setToConditions(int index,NamespaceCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
        this.conditions.set(index, item); return (A)this;
    }

    public A addToConditions(NamespaceCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
        for (NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A addAllToConditions(Collection<NamespaceCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<NamespaceCondition>();}
        for (NamespaceCondition item : items) {this.conditions.add(item);} return (A)this;
    }

    public A removeFromConditions(NamespaceCondition... items) {
        for (NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<NamespaceCondition> items) {
        for (NamespaceCondition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
    }

    public List<NamespaceCondition> getConditions() {
        return this.conditions;
    }

    public NamespaceCondition getCondition(int index) {
        return this.conditions.get(index);
    }

    public NamespaceCondition getFirstCondition() {
        return this.conditions.get(0);
    }

    public NamespaceCondition getLastCondition() {
        return this.conditions.get(conditions.size() - 1);
    }

    public NamespaceCondition getMatchingCondition(Predicate<NamespaceCondition> predicate) {
        for (NamespaceCondition item: conditions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<NamespaceCondition> predicate) {
        for (NamespaceCondition item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<NamespaceCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<NamespaceCondition>(); for (NamespaceCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(NamespaceCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (NamespaceCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
        return (A)addToConditions(new NamespaceCondition(lastTransitionTime, message, reason, status, type));
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase=phase; return (A) this;
    }

    public Boolean hasPhase() {
        return this.phase != null;
    }

    public A withNewPhase(String arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuilder arg1) {
        return (A)withPhase(new String(arg1));
    }

    public A withNewPhase(StringBuffer arg1) {
        return (A)withPhase(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProjectStatusFluentImpl that = (ProjectStatusFluentImpl) o;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        if (phase != null ? !phase.equals(that.phase) :that.phase != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(conditions,  phase,  super.hashCode());
    }

}
