package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface EgressNetworkPolicyListFluent<A extends EgressNetworkPolicyListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,EgressNetworkPolicy item);
    public A setToItems(int index,EgressNetworkPolicy item);
    public A addToItems(EgressNetworkPolicy... items);
    public A addAllToItems(Collection<EgressNetworkPolicy> items);
    public A removeFromItems(EgressNetworkPolicy... items);
    public A removeAllFromItems(Collection<EgressNetworkPolicy> items);
    public A removeMatchingFromItems(Predicate<EgressNetworkPolicyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<EgressNetworkPolicy> getItems();
    public List<EgressNetworkPolicy> buildItems();
    public EgressNetworkPolicy buildItem(int index);
    public EgressNetworkPolicy buildFirstItem();
    public EgressNetworkPolicy buildLastItem();
    public EgressNetworkPolicy buildMatchingItem(Predicate<EgressNetworkPolicyBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<EgressNetworkPolicyBuilder> predicate);
    public A withItems(List<EgressNetworkPolicy> items);
    public A withItems(EgressNetworkPolicy... items);
    public Boolean hasItems();
    public EgressNetworkPolicyListFluent.ItemsNested<A> addNewItem();
    public EgressNetworkPolicyListFluent.ItemsNested<A> addNewItemLike(EgressNetworkPolicy item);
    public EgressNetworkPolicyListFluent.ItemsNested<A> setNewItemLike(int index,EgressNetworkPolicy item);
    public EgressNetworkPolicyListFluent.ItemsNested<A> editItem(int index);
    public EgressNetworkPolicyListFluent.ItemsNested<A> editFirstItem();
    public EgressNetworkPolicyListFluent.ItemsNested<A> editLastItem();
    public EgressNetworkPolicyListFluent.ItemsNested<A> editMatchingItem(Predicate<EgressNetworkPolicyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EgressNetworkPolicyFluent<EgressNetworkPolicyListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
