package io.fabric8.openshift.api.model;

import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BuildStatusOutputToFluentImpl<A extends BuildStatusOutputToFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildStatusOutputToFluent<A> {

    private String imageDigest;

    public BuildStatusOutputToFluentImpl() { 
    }


    public BuildStatusOutputToFluentImpl(BuildStatusOutputTo instance) { 
        this.withImageDigest(instance.getImageDigest()); 
    }


    public String getImageDigest() {
        return this.imageDigest;
    }

    public A withImageDigest(String imageDigest) {
        this.imageDigest=imageDigest; return (A) this;
    }

    public Boolean hasImageDigest() {
        return this.imageDigest != null;
    }

    public A withNewImageDigest(String arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuilder arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public A withNewImageDigest(StringBuffer arg1) {
        return (A)withImageDigest(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuildStatusOutputToFluentImpl that = (BuildStatusOutputToFluentImpl) o;
        if (imageDigest != null ? !imageDigest.equals(that.imageDigest) :that.imageDigest != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(imageDigest,  super.hashCode());
    }

}
