package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class AWSPlatformStatusFluentImpl<A extends AWSPlatformStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AWSPlatformStatusFluent<A> {

    private String region;
    private List<AWSServiceEndpointBuilder> serviceEndpoints =  new ArrayList<AWSServiceEndpointBuilder>();

    public AWSPlatformStatusFluentImpl() { 
    }


    public AWSPlatformStatusFluentImpl(AWSPlatformStatus instance) { 
        this.withRegion(instance.getRegion()); 
        this.withServiceEndpoints(instance.getServiceEndpoints()); 
    }


    public String getRegion() {
        return this.region;
    }

    public A withRegion(String region) {
        this.region=region; return (A) this;
    }

    public Boolean hasRegion() {
        return this.region != null;
    }

    public A withNewRegion(String arg1) {
        return (A)withRegion(new String(arg1));
    }

    public A withNewRegion(StringBuilder arg1) {
        return (A)withRegion(new String(arg1));
    }

    public A withNewRegion(StringBuffer arg1) {
        return (A)withRegion(new String(arg1));
    }

    public A addToServiceEndpoints(int index,AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(index >= 0 ? index : _visitables.get("serviceEndpoints").size(), builder);this.serviceEndpoints.add(index >= 0 ? index : serviceEndpoints.size(), builder); return (A)this;
    }

    public A setToServiceEndpoints(int index,AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= _visitables.get("serviceEndpoints").size()) { _visitables.get("serviceEndpoints").add(builder); } else { _visitables.get("serviceEndpoints").set(index, builder);}
        if (index < 0 || index >= serviceEndpoints.size()) { serviceEndpoints.add(builder); } else { serviceEndpoints.set(index, builder);}
         return (A)this;
    }

    public A addToServiceEndpoints(AWSServiceEndpoint... items) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
    }

    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();}
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").add(builder);this.serviceEndpoints.add(builder);} return (A)this;
    }

    public A removeFromServiceEndpoints(AWSServiceEndpoint... items) {
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
    }

    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        for (AWSServiceEndpoint item : items) {AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);_visitables.get("serviceEndpoints").remove(builder);if (this.serviceEndpoints != null) {this.serviceEndpoints.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
        if (serviceEndpoints == null) return (A) this;
        final Iterator<AWSServiceEndpointBuilder> each = serviceEndpoints.iterator();
        final List visitables = _visitables.get("serviceEndpoints");
        while (each.hasNext()) {
          AWSServiceEndpointBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildServiceEndpoints instead.
 * @return The buildable object.
 */
@Deprecated public List<AWSServiceEndpoint> getServiceEndpoints() {
        return build(serviceEndpoints);
    }

    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return build(serviceEndpoints);
    }

    public AWSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(serviceEndpoints.size() - 1).build();
    }

    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item: serviceEndpoints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) { _visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);}
        if (serviceEndpoints != null) {this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>(); for (AWSServiceEndpoint item : serviceEndpoints){this.addToServiceEndpoints(item);}} else { this.serviceEndpoints = null;} return (A) this;
    }

    public A withServiceEndpoints(AWSServiceEndpoint... serviceEndpoints) {
        if (this.serviceEndpoints != null) {this.serviceEndpoints.clear();}
        if (serviceEndpoints != null) {for (AWSServiceEndpoint item :serviceEndpoints){ this.addToServiceEndpoints(item);}} return (A) this;
    }

    public Boolean hasServiceEndpoints() {
        return serviceEndpoints != null && !serviceEndpoints.isEmpty();
    }

    public A addNewServiceEndpoint(String name,String url) {
        return (A)addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index,AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (serviceEndpoints.size() <= index) throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (serviceEndpoints.size() == 0) throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        return setNewServiceEndpointLike(0, buildServiceEndpoint(0));
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = serviceEndpoints.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i=0;i<serviceEndpoints.size();i++) { 
        if (predicate.test(serviceEndpoints.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        return setNewServiceEndpointLike(index, buildServiceEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        AWSPlatformStatusFluentImpl that = (AWSPlatformStatusFluentImpl) o;
        if (region != null ? !region.equals(that.region) :that.region != null) return false;
        if (serviceEndpoints != null ? !serviceEndpoints.equals(that.serviceEndpoints) :that.serviceEndpoints != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(region,  serviceEndpoints,  super.hashCode());
    }

    public class ServiceEndpointsNestedImpl<N> extends AWSServiceEndpointFluentImpl<AWSPlatformStatusFluent.ServiceEndpointsNested<N>> implements AWSPlatformStatusFluent.ServiceEndpointsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final AWSServiceEndpointBuilder builder;
        private final int index;

        ServiceEndpointsNestedImpl(int index,AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new AWSServiceEndpointBuilder(this);
        }

        public N and() {
             return (N) AWSPlatformStatusFluentImpl.this.setToServiceEndpoints(index,builder.build());
        }

        public N endServiceEndpoint() {
             return and();
        }
    }


}
