package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.NamespaceCondition;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ProjectStatusFluent<A extends ProjectStatusFluent<A>> extends Fluent<A> {


    public A addToConditions(int index,NamespaceCondition item);
    public A setToConditions(int index,NamespaceCondition item);
    public A addToConditions(NamespaceCondition... items);
    public A addAllToConditions(Collection<NamespaceCondition> items);
    public A removeFromConditions(NamespaceCondition... items);
    public A removeAllFromConditions(Collection<NamespaceCondition> items);
    public List<NamespaceCondition> getConditions();
    public NamespaceCondition getCondition(int index);
    public NamespaceCondition getFirstCondition();
    public NamespaceCondition getLastCondition();
    public NamespaceCondition getMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<NamespaceCondition> predicate);
    public Boolean hasMatchingCondition(io.fabric8.kubernetes.api.builder.Predicate<NamespaceCondition> predicate);
    public A withConditions(List<NamespaceCondition> conditions);
    public A withConditions(NamespaceCondition... conditions);
    public Boolean hasConditions();
    public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type);
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public A withNewPhase(String arg1);
    public A withNewPhase(StringBuilder arg1);
    public A withNewPhase(StringBuffer arg1);
}
