
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "aws",
    "azure",
    "baremetal",
    "gcp",
    "ibmcloud",
    "openstack",
    "ovirt",
    "type",
    "vsphere"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class PlatformStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("aws")
    private AWSPlatformStatus aws;
    /**
     * 
     * 
     */
    @JsonProperty("azure")
    private AzurePlatformStatus azure;
    /**
     * 
     * 
     */
    @JsonProperty("baremetal")
    private BareMetalPlatformStatus baremetal;
    /**
     * 
     * 
     */
    @JsonProperty("gcp")
    private GCPPlatformStatus gcp;
    /**
     * 
     * 
     */
    @JsonProperty("ibmcloud")
    private IBMCloudPlatformStatus ibmcloud;
    /**
     * 
     * 
     */
    @JsonProperty("openstack")
    private OpenStackPlatformStatus openstack;
    /**
     * 
     * 
     */
    @JsonProperty("ovirt")
    private OvirtPlatformStatus ovirt;
    /**
     * 
     * 
     */
    @JsonProperty("type")
    private String type;
    /**
     * 
     * 
     */
    @JsonProperty("vsphere")
    private VSpherePlatformStatus vsphere;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public PlatformStatus() {
    }

    /**
     * 
     * @param baremetal
     * @param vsphere
     * @param gcp
     * @param ibmcloud
     * @param ovirt
     * @param openstack
     * @param aws
     * @param type
     * @param azure
     */
    public PlatformStatus(AWSPlatformStatus aws, AzurePlatformStatus azure, BareMetalPlatformStatus baremetal, GCPPlatformStatus gcp, IBMCloudPlatformStatus ibmcloud, OpenStackPlatformStatus openstack, OvirtPlatformStatus ovirt, String type, VSpherePlatformStatus vsphere) {
        this.aws = aws;
        this.azure = azure;
        this.baremetal = baremetal;
        this.gcp = gcp;
        this.ibmcloud = ibmcloud;
        this.openstack = openstack;
        this.ovirt = ovirt;
        this.type = type;
        this.vsphere = vsphere;
    }

    /**
     * 
     * 
     * @return
     *     The aws
     */
    @JsonProperty("aws")
    public AWSPlatformStatus getAws() {
        return aws;
    }

    /**
     * 
     * 
     * @param aws
     *     The aws
     */
    @JsonProperty("aws")
    public void setAws(AWSPlatformStatus aws) {
        this.aws = aws;
    }

    /**
     * 
     * 
     * @return
     *     The azure
     */
    @JsonProperty("azure")
    public AzurePlatformStatus getAzure() {
        return azure;
    }

    /**
     * 
     * 
     * @param azure
     *     The azure
     */
    @JsonProperty("azure")
    public void setAzure(AzurePlatformStatus azure) {
        this.azure = azure;
    }

    /**
     * 
     * 
     * @return
     *     The baremetal
     */
    @JsonProperty("baremetal")
    public BareMetalPlatformStatus getBaremetal() {
        return baremetal;
    }

    /**
     * 
     * 
     * @param baremetal
     *     The baremetal
     */
    @JsonProperty("baremetal")
    public void setBaremetal(BareMetalPlatformStatus baremetal) {
        this.baremetal = baremetal;
    }

    /**
     * 
     * 
     * @return
     *     The gcp
     */
    @JsonProperty("gcp")
    public GCPPlatformStatus getGcp() {
        return gcp;
    }

    /**
     * 
     * 
     * @param gcp
     *     The gcp
     */
    @JsonProperty("gcp")
    public void setGcp(GCPPlatformStatus gcp) {
        this.gcp = gcp;
    }

    /**
     * 
     * 
     * @return
     *     The ibmcloud
     */
    @JsonProperty("ibmcloud")
    public IBMCloudPlatformStatus getIbmcloud() {
        return ibmcloud;
    }

    /**
     * 
     * 
     * @param ibmcloud
     *     The ibmcloud
     */
    @JsonProperty("ibmcloud")
    public void setIbmcloud(IBMCloudPlatformStatus ibmcloud) {
        this.ibmcloud = ibmcloud;
    }

    /**
     * 
     * 
     * @return
     *     The openstack
     */
    @JsonProperty("openstack")
    public OpenStackPlatformStatus getOpenstack() {
        return openstack;
    }

    /**
     * 
     * 
     * @param openstack
     *     The openstack
     */
    @JsonProperty("openstack")
    public void setOpenstack(OpenStackPlatformStatus openstack) {
        this.openstack = openstack;
    }

    /**
     * 
     * 
     * @return
     *     The ovirt
     */
    @JsonProperty("ovirt")
    public OvirtPlatformStatus getOvirt() {
        return ovirt;
    }

    /**
     * 
     * 
     * @param ovirt
     *     The ovirt
     */
    @JsonProperty("ovirt")
    public void setOvirt(OvirtPlatformStatus ovirt) {
        this.ovirt = ovirt;
    }

    /**
     * 
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 
     * 
     * @return
     *     The vsphere
     */
    @JsonProperty("vsphere")
    public VSpherePlatformStatus getVsphere() {
        return vsphere;
    }

    /**
     * 
     * 
     * @param vsphere
     *     The vsphere
     */
    @JsonProperty("vsphere")
    public void setVsphere(VSpherePlatformStatus vsphere) {
        this.vsphere = vsphere;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
