package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodSecurityPolicyReviewSpecFluentImpl<A extends PodSecurityPolicyReviewSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicyReviewSpecFluent<A> {

    private List<String> serviceAccountNames = new ArrayList<String>();
    private PodTemplateSpecBuilder template;

    public PodSecurityPolicyReviewSpecFluentImpl() { 
    }


    public PodSecurityPolicyReviewSpecFluentImpl(PodSecurityPolicyReviewSpec instance) { 
        this.withServiceAccountNames(instance.getServiceAccountNames()); 
        this.withTemplate(instance.getTemplate()); 
    }


    public A addToServiceAccountNames(int index,String item) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
        this.serviceAccountNames.add(index, item);
        return (A)this;
    }

    public A setToServiceAccountNames(int index,String item) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
        this.serviceAccountNames.set(index, item); return (A)this;
    }

    public A addToServiceAccountNames(String... items) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
        for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
    }

    public A addAllToServiceAccountNames(Collection<String> items) {
        if (this.serviceAccountNames == null) {this.serviceAccountNames = new ArrayList<String>();}
        for (String item : items) {this.serviceAccountNames.add(item);} return (A)this;
    }

    public A removeFromServiceAccountNames(String... items) {
        for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
    }

    public A removeAllFromServiceAccountNames(Collection<String> items) {
        for (String item : items) {if (this.serviceAccountNames!= null){ this.serviceAccountNames.remove(item);}} return (A)this;
    }

    public List<String> getServiceAccountNames() {
        return this.serviceAccountNames;
    }

    public String getServiceAccountName(int index) {
        return this.serviceAccountNames.get(index);
    }

    public String getFirstServiceAccountName() {
        return this.serviceAccountNames.get(0);
    }

    public String getLastServiceAccountName() {
        return this.serviceAccountNames.get(serviceAccountNames.size() - 1);
    }

    public String getMatchingServiceAccountName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: serviceAccountNames) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingServiceAccountName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: serviceAccountNames) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withServiceAccountNames(List<String> serviceAccountNames) {
        if (this.serviceAccountNames != null) { _visitables.get("serviceAccountNames").removeAll(this.serviceAccountNames);}
        if (serviceAccountNames != null) {this.serviceAccountNames = new ArrayList<String>(); for (String item : serviceAccountNames){this.addToServiceAccountNames(item);}} else { this.serviceAccountNames = null;} return (A) this;
    }

    public A withServiceAccountNames(String... serviceAccountNames) {
        if (this.serviceAccountNames != null) {this.serviceAccountNames.clear();}
        if (serviceAccountNames != null) {for (String item :serviceAccountNames){ this.addToServiceAccountNames(item);}} return (A) this;
    }

    public Boolean hasServiceAccountNames() {
        return serviceAccountNames != null && !serviceAccountNames.isEmpty();
    }

    public A addNewServiceAccountName(String arg1) {
        return (A)addToServiceAccountNames(new String(arg1));
    }

    public A addNewServiceAccountName(StringBuilder arg1) {
        return (A)addToServiceAccountNames(new String(arg1));
    }

    public A addNewServiceAccountName(StringBuffer arg1) {
        return (A)addToServiceAccountNames(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public PodTemplateSpec buildTemplate() {
        return this.template!=null?this.template.build():null;
    }

    public A withTemplate(PodTemplateSpec template) {
        _visitables.get("template").remove(this.template);
        if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate() {
        return this.template != null;
    }

    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editTemplate() {
        return withNewTemplateLike(getTemplate());
    }

    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
    }

    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodSecurityPolicyReviewSpecFluentImpl that = (PodSecurityPolicyReviewSpecFluentImpl) o;
        if (serviceAccountNames != null ? !serviceAccountNames.equals(that.serviceAccountNames) :that.serviceAccountNames != null) return false;
        if (template != null ? !template.equals(that.template) :that.template != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(serviceAccountNames,  template,  super.hashCode());
    }

    public class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<PodSecurityPolicyReviewSpecFluent.TemplateNested<N>> implements PodSecurityPolicyReviewSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        public N and() {
             return (N) PodSecurityPolicyReviewSpecFluentImpl.this.withTemplate(builder.build());
        }

        public N endTemplate() {
             return and();
        }
    }


}
