package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class OAuthTemplatesFluentImpl<A extends OAuthTemplatesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements OAuthTemplatesFluent<A> {

    private SecretNameReferenceBuilder error;
    private SecretNameReferenceBuilder login;
    private SecretNameReferenceBuilder providerSelection;

    public OAuthTemplatesFluentImpl() { 
    }


    public OAuthTemplatesFluentImpl(OAuthTemplates instance) { 
        this.withError(instance.getError()); 
        this.withLogin(instance.getLogin()); 
        this.withProviderSelection(instance.getProviderSelection()); 
    }


    
/**
 * This method has been deprecated, please use method buildError instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getError() {
        return this.error!=null?this.error.build():null;
    }

    public SecretNameReference buildError() {
        return this.error!=null?this.error.build():null;
    }

    public A withError(SecretNameReference error) {
        _visitables.get("error").remove(this.error);
        if (error!=null){ this.error= new SecretNameReferenceBuilder(error); _visitables.get("error").add(this.error);} return (A) this;
    }

    public Boolean hasError() {
        return this.error != null;
    }

    public A withNewError(String name) {
        return (A)withError(new SecretNameReference(name));
    }

    public OAuthTemplatesFluent.ErrorNested<A> withNewError() {
        return new ErrorNestedImpl();
    }

    public OAuthTemplatesFluent.ErrorNested<A> withNewErrorLike(SecretNameReference item) {
        return new ErrorNestedImpl(item);
    }

    public OAuthTemplatesFluent.ErrorNested<A> editError() {
        return withNewErrorLike(getError());
    }

    public OAuthTemplatesFluent.ErrorNested<A> editOrNewError() {
        return withNewErrorLike(getError() != null ? getError(): new SecretNameReferenceBuilder().build());
    }

    public OAuthTemplatesFluent.ErrorNested<A> editOrNewErrorLike(SecretNameReference item) {
        return withNewErrorLike(getError() != null ? getError(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogin instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getLogin() {
        return this.login!=null?this.login.build():null;
    }

    public SecretNameReference buildLogin() {
        return this.login!=null?this.login.build():null;
    }

    public A withLogin(SecretNameReference login) {
        _visitables.get("login").remove(this.login);
        if (login!=null){ this.login= new SecretNameReferenceBuilder(login); _visitables.get("login").add(this.login);} return (A) this;
    }

    public Boolean hasLogin() {
        return this.login != null;
    }

    public A withNewLogin(String name) {
        return (A)withLogin(new SecretNameReference(name));
    }

    public OAuthTemplatesFluent.LoginNested<A> withNewLogin() {
        return new LoginNestedImpl();
    }

    public OAuthTemplatesFluent.LoginNested<A> withNewLoginLike(SecretNameReference item) {
        return new LoginNestedImpl(item);
    }

    public OAuthTemplatesFluent.LoginNested<A> editLogin() {
        return withNewLoginLike(getLogin());
    }

    public OAuthTemplatesFluent.LoginNested<A> editOrNewLogin() {
        return withNewLoginLike(getLogin() != null ? getLogin(): new SecretNameReferenceBuilder().build());
    }

    public OAuthTemplatesFluent.LoginNested<A> editOrNewLoginLike(SecretNameReference item) {
        return withNewLoginLike(getLogin() != null ? getLogin(): item);
    }

    
/**
 * This method has been deprecated, please use method buildProviderSelection instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getProviderSelection() {
        return this.providerSelection!=null?this.providerSelection.build():null;
    }

    public SecretNameReference buildProviderSelection() {
        return this.providerSelection!=null?this.providerSelection.build():null;
    }

    public A withProviderSelection(SecretNameReference providerSelection) {
        _visitables.get("providerSelection").remove(this.providerSelection);
        if (providerSelection!=null){ this.providerSelection= new SecretNameReferenceBuilder(providerSelection); _visitables.get("providerSelection").add(this.providerSelection);} return (A) this;
    }

    public Boolean hasProviderSelection() {
        return this.providerSelection != null;
    }

    public A withNewProviderSelection(String name) {
        return (A)withProviderSelection(new SecretNameReference(name));
    }

    public OAuthTemplatesFluent.ProviderSelectionNested<A> withNewProviderSelection() {
        return new ProviderSelectionNestedImpl();
    }

    public OAuthTemplatesFluent.ProviderSelectionNested<A> withNewProviderSelectionLike(SecretNameReference item) {
        return new ProviderSelectionNestedImpl(item);
    }

    public OAuthTemplatesFluent.ProviderSelectionNested<A> editProviderSelection() {
        return withNewProviderSelectionLike(getProviderSelection());
    }

    public OAuthTemplatesFluent.ProviderSelectionNested<A> editOrNewProviderSelection() {
        return withNewProviderSelectionLike(getProviderSelection() != null ? getProviderSelection(): new SecretNameReferenceBuilder().build());
    }

    public OAuthTemplatesFluent.ProviderSelectionNested<A> editOrNewProviderSelectionLike(SecretNameReference item) {
        return withNewProviderSelectionLike(getProviderSelection() != null ? getProviderSelection(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OAuthTemplatesFluentImpl that = (OAuthTemplatesFluentImpl) o;
        if (error != null ? !error.equals(that.error) :that.error != null) return false;
        if (login != null ? !login.equals(that.login) :that.login != null) return false;
        if (providerSelection != null ? !providerSelection.equals(that.providerSelection) :that.providerSelection != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(error,  login,  providerSelection,  super.hashCode());
    }

    public class ErrorNestedImpl<N> extends SecretNameReferenceFluentImpl<OAuthTemplatesFluent.ErrorNested<N>> implements OAuthTemplatesFluent.ErrorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        ErrorNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ErrorNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) OAuthTemplatesFluentImpl.this.withError(builder.build());
        }

        public N endError() {
             return and();
        }
    }


    public class LoginNestedImpl<N> extends SecretNameReferenceFluentImpl<OAuthTemplatesFluent.LoginNested<N>> implements OAuthTemplatesFluent.LoginNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        LoginNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        LoginNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) OAuthTemplatesFluentImpl.this.withLogin(builder.build());
        }

        public N endLogin() {
             return and();
        }
    }


    public class ProviderSelectionNestedImpl<N> extends SecretNameReferenceFluentImpl<OAuthTemplatesFluent.ProviderSelectionNested<N>> implements OAuthTemplatesFluent.ProviderSelectionNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        ProviderSelectionNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ProviderSelectionNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) OAuthTemplatesFluentImpl.this.withProviderSelection(builder.build());
        }

        public N endProviderSelection() {
             return and();
        }
    }


}
