package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.StringBuffer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;

public class ClusterVersionListFluentImpl<A extends ClusterVersionListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ClusterVersionListFluent<A> {

    private String apiVersion;
    private List<ClusterVersionBuilder> items =  new ArrayList<ClusterVersionBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterVersionListFluentImpl() { 
    }


    public ClusterVersionListFluentImpl(ClusterVersionList instance) { 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
    }


    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A addToItems(int index,ClusterVersion item) {
        if (this.items == null) {this.items = new ArrayList<ClusterVersionBuilder>();}
        ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("items").add(index >= 0 ? index : _visitables.get("items").size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,ClusterVersion item) {
        if (this.items == null) {this.items = new ArrayList<ClusterVersionBuilder>();}
        ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
        if (index < 0 || index >= _visitables.get("items").size()) { _visitables.get("items").add(builder); } else { _visitables.get("items").set(index, builder);}
        if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
         return (A)this;
    }

    public A addToItems(ClusterVersion... items) {
        if (this.items == null) {this.items = new ArrayList<ClusterVersionBuilder>();}
        for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<ClusterVersion> items) {
        if (this.items == null) {this.items = new ArrayList<ClusterVersionBuilder>();}
        for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ClusterVersion... items) {
        for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<ClusterVersion> items) {
        for (ClusterVersion item : items) {ClusterVersionBuilder builder = new ClusterVersionBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromItems(io.fabric8.kubernetes.api.builder.Predicate<ClusterVersionBuilder> predicate) {
        if (items == null) return (A) this;
        final Iterator<ClusterVersionBuilder> each = items.iterator();
        final List visitables = _visitables.get("items");
        while (each.hasNext()) {
          ClusterVersionBuilder builder = each.next();
          if (predicate.apply(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<ClusterVersion> getItems() {
        return build(items);
    }

    public List<ClusterVersion> buildItems() {
        return build(items);
    }

    public ClusterVersion buildItem(int index) {
        return this.items.get(index).build();
    }

    public ClusterVersion buildFirstItem() {
        return this.items.get(0).build();
    }

    public ClusterVersion buildLastItem() {
        return this.items.get(items.size() - 1).build();
    }

    public ClusterVersion buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterVersionBuilder> predicate) {
        for (ClusterVersionBuilder item: items) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterVersionBuilder> predicate) {
        for (ClusterVersionBuilder item: items) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withItems(List<ClusterVersion> items) {
        if (this.items != null) { _visitables.get("items").removeAll(this.items);}
        if (items != null) {this.items = new ArrayList<ClusterVersionBuilder>(); for (ClusterVersion item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(ClusterVersion... items) {
        if (this.items != null) {this.items.clear();}
        if (items != null) {for (ClusterVersion item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems() {
        return items != null && !items.isEmpty();
    }

    public ClusterVersionListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    public ClusterVersionListFluent.ItemsNested<A> addNewItemLike(ClusterVersion item) {
        return new ItemsNestedImpl(-1, item);
    }

    public ClusterVersionListFluent.ItemsNested<A> setNewItemLike(int index,ClusterVersion item) {
        return new ItemsNestedImpl(index, item);
    }

    public ClusterVersionListFluent.ItemsNested<A> editItem(int index) {
        if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
        return setNewItemLike(index, buildItem(index));
    }

    public ClusterVersionListFluent.ItemsNested<A> editFirstItem() {
        if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
        return setNewItemLike(0, buildItem(0));
    }

    public ClusterVersionListFluent.ItemsNested<A> editLastItem() {
        int index = items.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
        return setNewItemLike(index, buildItem(index));
    }

    public ClusterVersionListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterVersionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<items.size();i++) { 
        if (predicate.apply(items.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
        return setNewItemLike(index, buildItem(index));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public ListMeta getMetadata() {
        return this.metadata;
    }

    public A withMetadata(ListMeta metadata) {
        this.metadata=metadata; return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
        return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClusterVersionListFluentImpl that = (ClusterVersionListFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (items != null ? !items.equals(that.items) :that.items != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  super.hashCode());
    }

    public class ItemsNestedImpl<N> extends ClusterVersionFluentImpl<ClusterVersionListFluent.ItemsNested<N>> implements ClusterVersionListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ClusterVersionBuilder builder;
        private final int index;

        ItemsNestedImpl(int index,ClusterVersion item) {
            this.index = index;
            this.builder = new ClusterVersionBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterVersionBuilder(this);
        }

        public N and() {
             return (N) ClusterVersionListFluentImpl.this.setToItems(index,builder.build());
        }

        public N endItem() {
             return and();
        }
    }


}
