package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterOperatorFluent<A extends ClusterOperatorFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterOperatorFluent.MetadataNested<A> withNewMetadata();
    public ClusterOperatorFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterOperatorFluent.MetadataNested<A> editMetadata();
    public ClusterOperatorFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterOperatorFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public ClusterOperatorSpec getSpec();
    public ClusterOperatorSpec buildSpec();
    public A withSpec(ClusterOperatorSpec spec);
    public Boolean hasSpec();
    public ClusterOperatorFluent.SpecNested<A> withNewSpec();
    public ClusterOperatorFluent.SpecNested<A> withNewSpecLike(ClusterOperatorSpec item);
    public ClusterOperatorFluent.SpecNested<A> editSpec();
    public ClusterOperatorFluent.SpecNested<A> editOrNewSpec();
    public ClusterOperatorFluent.SpecNested<A> editOrNewSpecLike(ClusterOperatorSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public ClusterOperatorStatus getStatus();
    public ClusterOperatorStatus buildStatus();
    public A withStatus(ClusterOperatorStatus status);
    public Boolean hasStatus();
    public ClusterOperatorFluent.StatusNested<A> withNewStatus();
    public ClusterOperatorFluent.StatusNested<A> withNewStatusLike(ClusterOperatorStatus item);
    public ClusterOperatorFluent.StatusNested<A> editStatus();
    public ClusterOperatorFluent.StatusNested<A> editOrNewStatus();
    public ClusterOperatorFluent.StatusNested<A> editOrNewStatusLike(ClusterOperatorStatus item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterOperatorFluent.MetadataNested<N>> {

        public N and();
        public N endMetadata();    }


    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorSpecFluent<ClusterOperatorFluent.SpecNested<N>> {

        public N and();
        public N endSpec();    }


    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterOperatorStatusFluent<ClusterOperatorFluent.StatusNested<N>> {

        public N and();
        public N endStatus();    }


}
