package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ReleaseFluentImpl<A extends ReleaseFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ReleaseFluent<A> {

    private List<String> channels = new ArrayList<String>();
    private String image;
    private String url;
    private String version;

    public ReleaseFluentImpl() { 
    }


    public ReleaseFluentImpl(Release instance) { 
        this.withChannels(instance.getChannels()); 
        this.withImage(instance.getImage()); 
        this.withUrl(instance.getUrl()); 
        this.withVersion(instance.getVersion()); 
    }


    public A addToChannels(int index,String item) {
        if (this.channels == null) {this.channels = new ArrayList<String>();}
        this.channels.add(index, item);
        return (A)this;
    }

    public A setToChannels(int index,String item) {
        if (this.channels == null) {this.channels = new ArrayList<String>();}
        this.channels.set(index, item); return (A)this;
    }

    public A addToChannels(String... items) {
        if (this.channels == null) {this.channels = new ArrayList<String>();}
        for (String item : items) {this.channels.add(item);} return (A)this;
    }

    public A addAllToChannels(Collection<String> items) {
        if (this.channels == null) {this.channels = new ArrayList<String>();}
        for (String item : items) {this.channels.add(item);} return (A)this;
    }

    public A removeFromChannels(String... items) {
        for (String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
    }

    public A removeAllFromChannels(Collection<String> items) {
        for (String item : items) {if (this.channels!= null){ this.channels.remove(item);}} return (A)this;
    }

    public List<String> getChannels() {
        return this.channels;
    }

    public String getChannel(int index) {
        return this.channels.get(index);
    }

    public String getFirstChannel() {
        return this.channels.get(0);
    }

    public String getLastChannel() {
        return this.channels.get(channels.size() - 1);
    }

    public String getMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: channels) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingChannel(io.fabric8.kubernetes.api.builder.Predicate<String> predicate) {
        for (String item: channels) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withChannels(List<String> channels) {
        if (this.channels != null) { _visitables.get("channels").removeAll(this.channels);}
        if (channels != null) {this.channels = new ArrayList<String>(); for (String item : channels){this.addToChannels(item);}} else { this.channels = null;} return (A) this;
    }

    public A withChannels(String... channels) {
        if (this.channels != null) {this.channels.clear();}
        if (channels != null) {for (String item :channels){ this.addToChannels(item);}} return (A) this;
    }

    public Boolean hasChannels() {
        return channels != null && !channels.isEmpty();
    }

    public A addNewChannel(String arg1) {
        return (A)addToChannels(new String(arg1));
    }

    public A addNewChannel(StringBuilder arg1) {
        return (A)addToChannels(new String(arg1));
    }

    public A addNewChannel(StringBuffer arg1) {
        return (A)addToChannels(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url=url; return (A) this;
    }

    public Boolean hasUrl() {
        return this.url != null;
    }

    public A withNewUrl(String arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1) {
        return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1) {
        return (A)withUrl(new String(arg1));
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version=version; return (A) this;
    }

    public Boolean hasVersion() {
        return this.version != null;
    }

    public A withNewVersion(String arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1) {
        return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1) {
        return (A)withVersion(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ReleaseFluentImpl that = (ReleaseFluentImpl) o;
        if (channels != null ? !channels.equals(that.channels) :that.channels != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (url != null ? !url.equals(that.url) :that.url != null) return false;
        if (version != null ? !version.equals(that.version) :that.version != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(channels,  image,  url,  version,  super.hashCode());
    }

}
