package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ProxyStatusBuilder extends ProxyStatusFluentImpl<ProxyStatusBuilder> implements VisitableBuilder<ProxyStatus,ProxyStatusBuilder> {

    ProxyStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyStatusBuilder() { 
        this(true);
    }


    public ProxyStatusBuilder(Boolean validationEnabled) { 
        this(new ProxyStatus(), validationEnabled);
    }


    public ProxyStatusBuilder(ProxyStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ProxyStatus(), validationEnabled);
    }


    public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,ProxyStatus instance) { 
        this(fluent, instance, true);
    }


    public ProxyStatusBuilder(ProxyStatusFluent<?> fluent,ProxyStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withHttpProxy(instance.getHttpProxy()); 
        fluent.withHttpsProxy(instance.getHttpsProxy()); 
        fluent.withNoProxy(instance.getNoProxy()); 
        this.validationEnabled = validationEnabled; 
    }


    public ProxyStatusBuilder(ProxyStatus instance) { 
        this(instance,true);
    }


    public ProxyStatusBuilder(ProxyStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withHttpProxy(instance.getHttpProxy()); 
        this.withHttpsProxy(instance.getHttpsProxy()); 
        this.withNoProxy(instance.getNoProxy()); 
        this.validationEnabled = validationEnabled; 
    }


    public ProxyStatus build() {
        ProxyStatus buildable = new ProxyStatus(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ProxyStatusBuilder that = (ProxyStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
