package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class HTPasswdIdentityProviderFluentImpl<A extends HTPasswdIdentityProviderFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HTPasswdIdentityProviderFluent<A> {

    private SecretNameReferenceBuilder fileData;

    public HTPasswdIdentityProviderFluentImpl() { 
    }


    public HTPasswdIdentityProviderFluentImpl(HTPasswdIdentityProvider instance) { 
        this.withFileData(instance.getFileData()); 
    }


    
/**
 * This method has been deprecated, please use method buildFileData instead.
 * @return The buildable object.
 */
@Deprecated public SecretNameReference getFileData() {
        return this.fileData!=null?this.fileData.build():null;
    }

    public SecretNameReference buildFileData() {
        return this.fileData!=null?this.fileData.build():null;
    }

    public A withFileData(SecretNameReference fileData) {
        _visitables.get("fileData").remove(this.fileData);
        if (fileData!=null){ this.fileData= new SecretNameReferenceBuilder(fileData); _visitables.get("fileData").add(this.fileData);} return (A) this;
    }

    public Boolean hasFileData() {
        return this.fileData != null;
    }

    public A withNewFileData(String name) {
        return (A)withFileData(new SecretNameReference(name));
    }

    public HTPasswdIdentityProviderFluent.FileDataNested<A> withNewFileData() {
        return new FileDataNestedImpl();
    }

    public HTPasswdIdentityProviderFluent.FileDataNested<A> withNewFileDataLike(SecretNameReference item) {
        return new FileDataNestedImpl(item);
    }

    public HTPasswdIdentityProviderFluent.FileDataNested<A> editFileData() {
        return withNewFileDataLike(getFileData());
    }

    public HTPasswdIdentityProviderFluent.FileDataNested<A> editOrNewFileData() {
        return withNewFileDataLike(getFileData() != null ? getFileData(): new SecretNameReferenceBuilder().build());
    }

    public HTPasswdIdentityProviderFluent.FileDataNested<A> editOrNewFileDataLike(SecretNameReference item) {
        return withNewFileDataLike(getFileData() != null ? getFileData(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HTPasswdIdentityProviderFluentImpl that = (HTPasswdIdentityProviderFluentImpl) o;
        if (fileData != null ? !fileData.equals(that.fileData) :that.fileData != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fileData,  super.hashCode());
    }

    public class FileDataNestedImpl<N> extends SecretNameReferenceFluentImpl<HTPasswdIdentityProviderFluent.FileDataNested<N>> implements HTPasswdIdentityProviderFluent.FileDataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SecretNameReferenceBuilder builder;

        FileDataNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        FileDataNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        public N and() {
             return (N) HTPasswdIdentityProviderFluentImpl.this.withFileData(builder.build());
        }

        public N endFileData() {
             return and();
        }
    }


}
