package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ClusterResourceQuotaStatusBuilder extends ClusterResourceQuotaStatusFluentImpl<ClusterResourceQuotaStatusBuilder> implements VisitableBuilder<ClusterResourceQuotaStatus,ClusterResourceQuotaStatusBuilder> {

    ClusterResourceQuotaStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterResourceQuotaStatusBuilder() { 
        this(true);
    }


    public ClusterResourceQuotaStatusBuilder(Boolean validationEnabled) { 
        this(new ClusterResourceQuotaStatus(), validationEnabled);
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ClusterResourceQuotaStatus(), validationEnabled);
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,ClusterResourceQuotaStatus instance) { 
        this(fluent, instance, true);
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatusFluent<?> fluent,ClusterResourceQuotaStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withNamespaces(instance.getNamespaces()); 
        fluent.withTotal(instance.getTotal()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatus instance) { 
        this(instance,true);
    }


    public ClusterResourceQuotaStatusBuilder(ClusterResourceQuotaStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withNamespaces(instance.getNamespaces()); 
        this.withTotal(instance.getTotal()); 
        this.validationEnabled = validationEnabled; 
    }


    public ClusterResourceQuotaStatus build() {
        ClusterResourceQuotaStatus buildable = new ClusterResourceQuotaStatus(fluent.getNamespaces(),fluent.getTotal());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ClusterResourceQuotaStatusBuilder that = (ClusterResourceQuotaStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
