package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppliedClusterResourceQuotaBuilder extends AppliedClusterResourceQuotaFluentImpl<AppliedClusterResourceQuotaBuilder> implements VisitableBuilder<AppliedClusterResourceQuota,AppliedClusterResourceQuotaBuilder> {

    AppliedClusterResourceQuotaFluent<?> fluent;
    Boolean validationEnabled;

    public AppliedClusterResourceQuotaBuilder() { 
        this(true);
    }


    public AppliedClusterResourceQuotaBuilder(Boolean validationEnabled) { 
        this(new AppliedClusterResourceQuota(), validationEnabled);
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent) { 
        this(fluent, true);
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new AppliedClusterResourceQuota(), validationEnabled);
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,AppliedClusterResourceQuota instance) { 
        this(fluent, instance, true);
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuotaFluent<?> fluent,AppliedClusterResourceQuota instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuota instance) { 
        this(instance,true);
    }


    public AppliedClusterResourceQuotaBuilder(AppliedClusterResourceQuota instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }


    public AppliedClusterResourceQuota build() {
        AppliedClusterResourceQuota buildable = new AppliedClusterResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        AppliedClusterResourceQuotaBuilder that = (AppliedClusterResourceQuotaBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
