package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PodSecurityPolicyReviewSpecFluent<A extends PodSecurityPolicyReviewSpecFluent<A>> extends Fluent<A> {


    public A addToServiceAccountNames(int index,String item);
    public A setToServiceAccountNames(int index,String item);
    public A addToServiceAccountNames(String... items);
    public A addAllToServiceAccountNames(Collection<String> items);
    public A removeFromServiceAccountNames(String... items);
    public A removeAllFromServiceAccountNames(Collection<String> items);
    public List<String> getServiceAccountNames();
    public String getServiceAccountName(int index);
    public String getFirstServiceAccountName();
    public String getLastServiceAccountName();
    public String getMatchingServiceAccountName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public Boolean hasMatchingServiceAccountName(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withServiceAccountNames(List<String> serviceAccountNames);
    public A withServiceAccountNames(String... serviceAccountNames);
    public Boolean hasServiceAccountNames();
    public A addNewServiceAccountName(String arg1);
    public A addNewServiceAccountName(StringBuilder arg1);
    public A addNewServiceAccountName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplate();
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editTemplate();
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplate();
    public PodSecurityPolicyReviewSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<PodSecurityPolicyReviewSpecFluent.TemplateNested<N>> {

        public N and();
        public N endTemplate();    }


}
