package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OpenStackPlatformStatusBuilder extends OpenStackPlatformStatusFluentImpl<OpenStackPlatformStatusBuilder> implements VisitableBuilder<OpenStackPlatformStatus,OpenStackPlatformStatusBuilder> {

    OpenStackPlatformStatusFluent<?> fluent;
    Boolean validationEnabled;

    public OpenStackPlatformStatusBuilder() { 
        this(true);
    }


    public OpenStackPlatformStatusBuilder(Boolean validationEnabled) { 
        this(new OpenStackPlatformStatus(), validationEnabled);
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent) { 
        this(fluent, true);
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new OpenStackPlatformStatus(), validationEnabled);
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,OpenStackPlatformStatus instance) { 
        this(fluent, instance, true);
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatusFluent<?> fluent,OpenStackPlatformStatus instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        fluent.withCloudName(instance.getCloudName()); 
        fluent.withIngressIP(instance.getIngressIP()); 
        fluent.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatus instance) { 
        this(instance,true);
    }


    public OpenStackPlatformStatusBuilder(OpenStackPlatformStatus instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
        this.withCloudName(instance.getCloudName()); 
        this.withIngressIP(instance.getIngressIP()); 
        this.withNodeDNSIP(instance.getNodeDNSIP()); 
        this.validationEnabled = validationEnabled; 
    }


    public OpenStackPlatformStatus build() {
        OpenStackPlatformStatus buildable = new OpenStackPlatformStatus(fluent.getApiServerInternalIP(),fluent.getCloudName(),fluent.getIngressIP(),fluent.getNodeDNSIP());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OpenStackPlatformStatusBuilder that = (OpenStackPlatformStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
