package io.fabric8.openshift.api.model.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPPoolSpecBuilder extends IPPoolSpecFluent<IPPoolSpecBuilder> implements VisitableBuilder<IPPoolSpec,IPPoolSpecBuilder>{
  public IPPoolSpecBuilder() {
    this(false);
  }
  public IPPoolSpecBuilder(Boolean validationEnabled) {
    this(new IPPoolSpec(), validationEnabled);
  }
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPPoolSpec(), validationEnabled);
  }
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent,IPPoolSpec instance) {
    this(fluent, instance, false);
  }
  public IPPoolSpecBuilder(IPPoolSpecFluent<?> fluent,IPPoolSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IPPoolSpec());

    if (instance != null) {
      fluent.withAllocations(instance.getAllocations());
      fluent.withRange(instance.getRange());
      fluent.withAllocations(instance.getAllocations());
      fluent.withRange(instance.getRange());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPPoolSpecBuilder(IPPoolSpec instance) {
    this(instance,false);
  }
  public IPPoolSpecBuilder(IPPoolSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IPPoolSpec());

    if (instance != null) {
      this.withAllocations(instance.getAllocations());
      this.withRange(instance.getRange());
      this.withAllocations(instance.getAllocations());
      this.withRange(instance.getRange());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPPoolSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IPPoolSpec build() {
    IPPoolSpec buildable = new IPPoolSpec(fluent.getAllocations(),fluent.getRange());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}