package io.fabric8.openshift.api.model.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPAllocationBuilder extends IPAllocationFluent<IPAllocationBuilder> implements VisitableBuilder<IPAllocation,IPAllocationBuilder>{
  public IPAllocationBuilder() {
    this(false);
  }
  public IPAllocationBuilder(Boolean validationEnabled) {
    this(new IPAllocation(), validationEnabled);
  }
  public IPAllocationBuilder(IPAllocationFluent<?> fluent) {
    this(fluent, false);
  }
  public IPAllocationBuilder(IPAllocationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPAllocation(), validationEnabled);
  }
  public IPAllocationBuilder(IPAllocationFluent<?> fluent,IPAllocation instance) {
    this(fluent, instance, false);
  }
  public IPAllocationBuilder(IPAllocationFluent<?> fluent,IPAllocation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IPAllocation());

    if (instance != null) {
      fluent.withId(instance.getId());
      fluent.withPodref(instance.getPodref());
      fluent.withId(instance.getId());
      fluent.withPodref(instance.getPodref());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPAllocationBuilder(IPAllocation instance) {
    this(instance,false);
  }
  public IPAllocationBuilder(IPAllocation instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IPAllocation());

    if (instance != null) {
      this.withId(instance.getId());
      this.withPodref(instance.getPodref());
      this.withId(instance.getId());
      this.withPodref(instance.getPodref());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPAllocationFluent<?> fluent;
  Boolean validationEnabled;
  public IPAllocation build() {
    IPAllocation buildable = new IPAllocation(fluent.getId(),fluent.getPodref());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}