package io.fabric8.openshift.api.model.whereabouts.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IPPoolBuilder extends IPPoolFluentImpl<IPPoolBuilder> implements VisitableBuilder<IPPool,IPPoolBuilder>{
  public IPPoolBuilder() {
    this(false);
  }
  public IPPoolBuilder(Boolean validationEnabled) {
    this(new IPPool(), validationEnabled);
  }
  public IPPoolBuilder(IPPoolFluent<?> fluent) {
    this(fluent, false);
  }
  public IPPoolBuilder(IPPoolFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IPPool(), validationEnabled);
  }
  public IPPoolBuilder(IPPoolFluent<?> fluent,IPPool instance) {
    this(fluent, instance, false);
  }
  public IPPoolBuilder(IPPoolFluent<?> fluent,IPPool instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IPPoolBuilder(IPPool instance) {
    this(instance,false);
  }
  public IPPoolBuilder(IPPool instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IPPoolFluent<?> fluent;
  Boolean validationEnabled;
  public IPPool build() {
    IPPool buildable = new IPPool(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}