package io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class StorageStateStatusBuilder extends io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluentImpl<io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus,io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusBuilder>{
  public StorageStateStatusBuilder() {
    this(false);
  }
  public StorageStateStatusBuilder(java.lang.Boolean validationEnabled) {
    this(new StorageStateStatus(), validationEnabled);
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new StorageStateStatus(), validationEnabled);
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluent<?> fluent,io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus instance) {
    this(fluent, instance, false);
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluent<?> fluent,io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash()); 
    fluent.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    fluent.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes()); 
    this.validationEnabled = validationEnabled; 
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus instance) {
    this(instance,false);
  }
  public StorageStateStatusBuilder(io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCurrentStorageVersionHash(instance.getCurrentStorageVersionHash()); 
    this.withLastHeartbeatTime(instance.getLastHeartbeatTime()); 
    this.withPersistedStorageVersionHashes(instance.getPersistedStorageVersionHashes()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.storageversionmigrator.v1alpha1.StorageStateStatus build() {
    StorageStateStatus buildable = new StorageStateStatus(fluent.getCurrentStorageVersionHash(),fluent.getLastHeartbeatTime(),fluent.getPersistedStorageVersionHashes());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StorageStateStatusBuilder that = (StorageStateStatusBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}