package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.rbac.PolicyRule;
import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StrategyDeploymentPermissionsFluent<A extends StrategyDeploymentPermissionsFluent<A>> extends BaseFluent<A>{
  public StrategyDeploymentPermissionsFluent() {
  }
  
  public StrategyDeploymentPermissionsFluent(StrategyDeploymentPermissions instance) {
    this.copyInstance(instance);
  }
  private List<PolicyRule> rules = new ArrayList<PolicyRule>();
  private String serviceAccountName;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StrategyDeploymentPermissions instance) {
    instance = (instance != null ? instance : new StrategyDeploymentPermissions());
  
    if (instance != null) {
        this.withRules(instance.getRules());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withRules(instance.getRules());
        this.withServiceAccountName(instance.getServiceAccountName());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public A addToRules(int index,PolicyRule item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
    this.rules.add(index, item);
    return (A)this;
  }
  
  public A setToRules(int index,PolicyRule item) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
    this.rules.set(index, item); return (A)this;
  }
  
  public A addToRules(io.fabric8.kubernetes.api.model.rbac.PolicyRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
    for (PolicyRule item : items) {this.rules.add(item);} return (A)this;
  }
  
  public A addAllToRules(Collection<PolicyRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<PolicyRule>();}
    for (PolicyRule item : items) {this.rules.add(item);} return (A)this;
  }
  
  public A removeFromRules(io.fabric8.kubernetes.api.model.rbac.PolicyRule... items) {
    if (this.rules == null) return (A)this;
    for (PolicyRule item : items) { this.rules.remove(item);} return (A)this;
  }
  
  public A removeAllFromRules(Collection<PolicyRule> items) {
    if (this.rules == null) return (A)this;
    for (PolicyRule item : items) { this.rules.remove(item);} return (A)this;
  }
  
  public List<PolicyRule> getRules() {
    return this.rules;
  }
  
  public PolicyRule getRule(int index) {
    return this.rules.get(index);
  }
  
  public PolicyRule getFirstRule() {
    return this.rules.get(0);
  }
  
  public PolicyRule getLastRule() {
    return this.rules.get(rules.size() - 1);
  }
  
  public PolicyRule getMatchingRule(Predicate<PolicyRule> predicate) {
    for (PolicyRule item: rules) { if(predicate.test(item)){ return item;} } return null;
  }
  
  public boolean hasMatchingRule(Predicate<PolicyRule> predicate) {
    for (PolicyRule item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  
  public A withRules(List<PolicyRule> rules) {
    if (rules != null) {this.rules = new ArrayList(); for (PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  
  public A withRules(io.fabric8.kubernetes.api.model.rbac.PolicyRule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  
  public boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName=serviceAccountName; return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StrategyDeploymentPermissionsFluent that = (StrategyDeploymentPermissionsFluent) o;
    if (!java.util.Objects.equals(rules, that.rules)) return false;
  
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(rules,  serviceAccountName,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}