package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CatalogSourceSpecFluent<A extends CatalogSourceSpecFluent<A>> extends BaseFluent<A>{
  public CatalogSourceSpecFluent() {
  }
  public CatalogSourceSpecFluent(CatalogSourceSpec instance) {
    instance = (instance != null ? instance : new CatalogSourceSpec());

    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withConfigMap(instance.getConfigMap());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withImage(instance.getImage());
      this.withPriority(instance.getPriority());
      this.withPublisher(instance.getPublisher());
      this.withSecrets(instance.getSecrets());
      this.withSourceType(instance.getSourceType());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withAddress(instance.getAddress());
      this.withConfigMap(instance.getConfigMap());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withImage(instance.getImage());
      this.withPriority(instance.getPriority());
      this.withPublisher(instance.getPublisher());
      this.withSecrets(instance.getSecrets());
      this.withSourceType(instance.getSourceType());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String address;
  private String configMap;
  private String description;
  private String displayName;
  private IconBuilder icon;
  private String image;
  private Integer priority;
  private String publisher;
  private List<String> secrets = new ArrayList<String>();
  private String sourceType;
  private UpdateStrategyBuilder updateStrategy;
  private Map<String,Object> additionalProperties;
  public String getAddress() {
    return this.address;
  }
  public A withAddress(String address) {
    this.address=address; return (A) this;
  }
  public boolean hasAddress() {
    return this.address != null;
  }
  public String getConfigMap() {
    return this.configMap;
  }
  public A withConfigMap(String configMap) {
    this.configMap=configMap; return (A) this;
  }
  public boolean hasConfigMap() {
    return this.configMap != null;
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public boolean hasDisplayName() {
    return this.displayName != null;
  }
  public Icon buildIcon() {
    return this.icon!=null ?this.icon.build():null;
  }
  public A withIcon(Icon icon) {
    _visitables.get("icon").remove(this.icon);
    if (icon!=null){ this.icon= new IconBuilder(icon); _visitables.get("icon").add(this.icon);} else { this.icon = null; _visitables.get("icon").remove(this.icon); } return (A) this;
  }
  public boolean hasIcon() {
    return this.icon != null;
  }
  public A withNewIcon(String base64data,String mediatype) {
    return (A)withIcon(new Icon(base64data, mediatype));
  }
  public IconNested<A> withNewIcon() {
    return new IconNested(null);
  }
  public IconNested<A> withNewIconLike(Icon item) {
    return new IconNested(item);
  }
  public IconNested<A> editIcon() {
    return withNewIconLike(java.util.Optional.ofNullable(buildIcon()).orElse(null));
  }
  public IconNested<A> editOrNewIcon() {
    return withNewIconLike(java.util.Optional.ofNullable(buildIcon()).orElse(new IconBuilder().build()));
  }
  public IconNested<A> editOrNewIconLike(Icon item) {
    return withNewIconLike(java.util.Optional.ofNullable(buildIcon()).orElse(item));
  }
  public String getImage() {
    return this.image;
  }
  public A withImage(String image) {
    this.image=image; return (A) this;
  }
  public boolean hasImage() {
    return this.image != null;
  }
  public Integer getPriority() {
    return this.priority;
  }
  public A withPriority(Integer priority) {
    this.priority=priority; return (A) this;
  }
  public boolean hasPriority() {
    return this.priority != null;
  }
  public String getPublisher() {
    return this.publisher;
  }
  public A withPublisher(String publisher) {
    this.publisher=publisher; return (A) this;
  }
  public boolean hasPublisher() {
    return this.publisher != null;
  }
  public A addToSecrets(int index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.add(index, item);
    return (A)this;
  }
  public A setToSecrets(int index,String item) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    this.secrets.set(index, item); return (A)this;
  }
  public A addToSecrets(java.lang.String... items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A addAllToSecrets(Collection<String> items) {
    if (this.secrets == null) {this.secrets = new ArrayList<String>();}
    for (String item : items) {this.secrets.add(item);} return (A)this;
  }
  public A removeFromSecrets(java.lang.String... items) {
    if (this.secrets == null) return (A)this;
    for (String item : items) { this.secrets.remove(item);} return (A)this;
  }
  public A removeAllFromSecrets(Collection<String> items) {
    if (this.secrets == null) return (A)this;
    for (String item : items) { this.secrets.remove(item);} return (A)this;
  }
  public List<String> getSecrets() {
    return this.secrets;
  }
  public String getSecret(int index) {
    return this.secrets.get(index);
  }
  public String getFirstSecret() {
    return this.secrets.get(0);
  }
  public String getLastSecret() {
    return this.secrets.get(secrets.size() - 1);
  }
  public String getMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSecret(Predicate<String> predicate) {
    for (String item: secrets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSecrets(List<String> secrets) {
    if (secrets != null) {this.secrets = new ArrayList(); for (String item : secrets){this.addToSecrets(item);}} else { this.secrets = null;} return (A) this;
  }
  public A withSecrets(java.lang.String... secrets) {
    if (this.secrets != null) {this.secrets.clear(); _visitables.remove("secrets"); }
    if (secrets != null) {for (String item :secrets){ this.addToSecrets(item);}} return (A) this;
  }
  public boolean hasSecrets() {
    return secrets != null && !secrets.isEmpty();
  }
  public String getSourceType() {
    return this.sourceType;
  }
  public A withSourceType(String sourceType) {
    this.sourceType=sourceType; return (A) this;
  }
  public boolean hasSourceType() {
    return this.sourceType != null;
  }
  public UpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public A withUpdateStrategy(UpdateStrategy updateStrategy) {
    _visitables.get("updateStrategy").remove(this.updateStrategy);
    if (updateStrategy!=null){ this.updateStrategy= new UpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} else { this.updateStrategy = null; _visitables.get("updateStrategy").remove(this.updateStrategy); } return (A) this;
  }
  public boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  public UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new UpdateStrategyNested(null);
  }
  public UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item) {
    return new UpdateStrategyNested(item);
  }
  public UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(null));
  }
  public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(new UpdateStrategyBuilder().build()));
  }
  public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item) {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CatalogSourceSpecFluent that = (CatalogSourceSpecFluent) o;
    if (!java.util.Objects.equals(address, that.address)) return false;

    if (!java.util.Objects.equals(configMap, that.configMap)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(icon, that.icon)) return false;

    if (!java.util.Objects.equals(image, that.image)) return false;

    if (!java.util.Objects.equals(priority, that.priority)) return false;

    if (!java.util.Objects.equals(publisher, that.publisher)) return false;

    if (!java.util.Objects.equals(secrets, that.secrets)) return false;

    if (!java.util.Objects.equals(sourceType, that.sourceType)) return false;

    if (!java.util.Objects.equals(updateStrategy, that.updateStrategy)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  configMap,  description,  displayName,  icon,  image,  priority,  publisher,  secrets,  sourceType,  updateStrategy,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (configMap != null) { sb.append("configMap:"); sb.append(configMap + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (priority != null) { sb.append("priority:"); sb.append(priority + ","); }
    if (publisher != null) { sb.append("publisher:"); sb.append(publisher + ","); }
    if (secrets != null && !secrets.isEmpty()) { sb.append("secrets:"); sb.append(secrets + ","); }
    if (sourceType != null) { sb.append("sourceType:"); sb.append(sourceType + ","); }
    if (updateStrategy != null) { sb.append("updateStrategy:"); sb.append(updateStrategy + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IconNested<N> extends IconFluent<IconNested<N>> implements Nested<N>{
    IconNested(Icon item) {
      this.builder = new IconBuilder(this, item);
    }
    IconBuilder builder;
    public N and() {
      return (N) CatalogSourceSpecFluent.this.withIcon(builder.build());
    }
    public N endIcon() {
      return and();
    }
    
  }
  public class UpdateStrategyNested<N> extends UpdateStrategyFluent<UpdateStrategyNested<N>> implements Nested<N>{
    UpdateStrategyNested(UpdateStrategy item) {
      this.builder = new UpdateStrategyBuilder(this, item);
    }
    UpdateStrategyBuilder builder;
    public N and() {
      return (N) CatalogSourceSpecFluent.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy() {
      return and();
    }
    
  }
  
}