package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorConditionSpecBuilder extends OperatorConditionSpecFluent<OperatorConditionSpecBuilder> implements VisitableBuilder<OperatorConditionSpec,OperatorConditionSpecBuilder>{
  public OperatorConditionSpecBuilder() {
    this(false);
  }
  public OperatorConditionSpecBuilder(Boolean validationEnabled) {
    this(new OperatorConditionSpec(), validationEnabled);
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorConditionSpec(), validationEnabled);
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpecFluent<?> fluent,OperatorConditionSpec instance) {
    this(fluent, instance, false);
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpecFluent<?> fluent,OperatorConditionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new OperatorConditionSpec());

    if (instance != null) {
      fluent.withDeployments(instance.getDeployments());
      fluent.withOverrides(instance.getOverrides());
      fluent.withServiceAccounts(instance.getServiceAccounts());
      fluent.withDeployments(instance.getDeployments());
      fluent.withOverrides(instance.getOverrides());
      fluent.withServiceAccounts(instance.getServiceAccounts());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpec instance) {
    this(instance,false);
  }
  public OperatorConditionSpecBuilder(OperatorConditionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new OperatorConditionSpec());

    if (instance != null) {
      this.withDeployments(instance.getDeployments());
      this.withOverrides(instance.getOverrides());
      this.withServiceAccounts(instance.getServiceAccounts());
      this.withDeployments(instance.getDeployments());
      this.withOverrides(instance.getOverrides());
      this.withServiceAccounts(instance.getServiceAccounts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorConditionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorConditionSpec build() {
    OperatorConditionSpec buildable = new OperatorConditionSpec(fluent.getDeployments(),fluent.getOverrides(),fluent.getServiceAccounts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}