package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorBuilder extends OperatorFluent<OperatorBuilder> implements VisitableBuilder<Operator,OperatorBuilder>{
  public OperatorBuilder() {
    this(false);
  }
  public OperatorBuilder(Boolean validationEnabled) {
    this(new Operator(), validationEnabled);
  }
  public OperatorBuilder(OperatorFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorBuilder(OperatorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Operator(), validationEnabled);
  }
  public OperatorBuilder(OperatorFluent<?> fluent,Operator instance) {
    this(fluent, instance, false);
  }
  public OperatorBuilder(OperatorFluent<?> fluent,Operator instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Operator());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorBuilder(Operator instance) {
    this(instance,false);
  }
  public OperatorBuilder(Operator instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Operator());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorFluent<?> fluent;
  Boolean validationEnabled;
  public Operator build() {
    Operator buildable = new Operator(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}