package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ComponentsBuilder extends ComponentsFluent<ComponentsBuilder> implements VisitableBuilder<Components,ComponentsBuilder>{
  public ComponentsBuilder() {
    this(false);
  }
  public ComponentsBuilder(Boolean validationEnabled) {
    this(new Components(), validationEnabled);
  }
  public ComponentsBuilder(ComponentsFluent<?> fluent) {
    this(fluent, false);
  }
  public ComponentsBuilder(ComponentsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Components(), validationEnabled);
  }
  public ComponentsBuilder(ComponentsFluent<?> fluent,Components instance) {
    this(fluent, instance, false);
  }
  public ComponentsBuilder(ComponentsFluent<?> fluent,Components instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Components());

    if (instance != null) {
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withRefs(instance.getRefs());
      fluent.withLabelSelector(instance.getLabelSelector());
      fluent.withRefs(instance.getRefs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ComponentsBuilder(Components instance) {
    this(instance,false);
  }
  public ComponentsBuilder(Components instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Components());

    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withRefs(instance.getRefs());
      this.withLabelSelector(instance.getLabelSelector());
      this.withRefs(instance.getRefs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ComponentsFluent<?> fluent;
  Boolean validationEnabled;
  public Components build() {
    Components buildable = new Components(fluent.buildLabelSelector(),fluent.getRefs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}