package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebhookDescriptionFluentImpl<A extends WebhookDescriptionFluent<A>> extends BaseFluent<A> implements WebhookDescriptionFluent<A>{
  public WebhookDescriptionFluentImpl() {
  }
  public WebhookDescriptionFluentImpl(WebhookDescription instance) {
    if (instance != null) {
      this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
      this.withContainerPort(instance.getContainerPort());
      this.withConversionCRDs(instance.getConversionCRDs());
      this.withDeploymentName(instance.getDeploymentName());
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withGenerateName(instance.getGenerateName());
      this.withMatchPolicy(instance.getMatchPolicy());
      this.withObjectSelector(instance.getObjectSelector());
      this.withReinvocationPolicy(instance.getReinvocationPolicy());
      this.withRules(instance.getRules());
      this.withSideEffects(instance.getSideEffects());
      this.withTargetPort(instance.getTargetPort());
      this.withTimeoutSeconds(instance.getTimeoutSeconds());
      this.withType(instance.getType());
      this.withWebhookPath(instance.getWebhookPath());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> admissionReviewVersions = new ArrayList<String>();
  private Integer containerPort;
  private List<String> conversionCRDs = new ArrayList<String>();
  private String deploymentName;
  private String failurePolicy;
  private String generateName;
  private String matchPolicy;
  private LabelSelectorBuilder objectSelector;
  private String reinvocationPolicy;
  private List<RuleWithOperations> rules = new ArrayList<RuleWithOperations>();
  private String sideEffects;
  private IntOrStringBuilder targetPort;
  private Integer timeoutSeconds;
  private String type;
  private String webhookPath;
  private Map<String,Object> additionalProperties;
  public A addToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.add(index, item);
    return (A)this;
  }
  public A setToAdmissionReviewVersions(int index,String item) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    this.admissionReviewVersions.set(index, item); return (A)this;
  }
  public A addToAdmissionReviewVersions(java.lang.String... items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  public A addAllToAdmissionReviewVersions(Collection<String> items) {
    if (this.admissionReviewVersions == null) {this.admissionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.admissionReviewVersions.add(item);} return (A)this;
  }
  public A removeFromAdmissionReviewVersions(java.lang.String... items) {
    for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
    for (String item : items) {if (this.admissionReviewVersions!= null){ this.admissionReviewVersions.remove(item);}} return (A)this;
  }
  public List<String> getAdmissionReviewVersions() {
    return this.admissionReviewVersions;
  }
  public String getAdmissionReviewVersion(int index) {
    return this.admissionReviewVersions.get(index);
  }
  public String getFirstAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(0);
  }
  public String getLastAdmissionReviewVersion() {
    return this.admissionReviewVersions.get(admissionReviewVersions.size() - 1);
  }
  public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
    for (String item: admissionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
    if (admissionReviewVersions != null) {this.admissionReviewVersions = new ArrayList(); for (String item : admissionReviewVersions){this.addToAdmissionReviewVersions(item);}} else { this.admissionReviewVersions = null;} return (A) this;
  }
  public A withAdmissionReviewVersions(java.lang.String... admissionReviewVersions) {
    if (this.admissionReviewVersions != null) {this.admissionReviewVersions.clear(); _visitables.remove("admissionReviewVersions"); }
    if (admissionReviewVersions != null) {for (String item :admissionReviewVersions){ this.addToAdmissionReviewVersions(item);}} return (A) this;
  }
  public Boolean hasAdmissionReviewVersions() {
    return admissionReviewVersions != null && !admissionReviewVersions.isEmpty();
  }
  public Integer getContainerPort() {
    return this.containerPort;
  }
  public A withContainerPort(Integer containerPort) {
    this.containerPort=containerPort; return (A) this;
  }
  public Boolean hasContainerPort() {
    return this.containerPort != null;
  }
  public A addToConversionCRDs(int index,String item) {
    if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
    this.conversionCRDs.add(index, item);
    return (A)this;
  }
  public A setToConversionCRDs(int index,String item) {
    if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
    this.conversionCRDs.set(index, item); return (A)this;
  }
  public A addToConversionCRDs(java.lang.String... items) {
    if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
    for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
  }
  public A addAllToConversionCRDs(Collection<String> items) {
    if (this.conversionCRDs == null) {this.conversionCRDs = new ArrayList<String>();}
    for (String item : items) {this.conversionCRDs.add(item);} return (A)this;
  }
  public A removeFromConversionCRDs(java.lang.String... items) {
    for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
  }
  public A removeAllFromConversionCRDs(Collection<String> items) {
    for (String item : items) {if (this.conversionCRDs!= null){ this.conversionCRDs.remove(item);}} return (A)this;
  }
  public List<String> getConversionCRDs() {
    return this.conversionCRDs;
  }
  public String getConversionCRD(int index) {
    return this.conversionCRDs.get(index);
  }
  public String getFirstConversionCRD() {
    return this.conversionCRDs.get(0);
  }
  public String getLastConversionCRD() {
    return this.conversionCRDs.get(conversionCRDs.size() - 1);
  }
  public String getMatchingConversionCRD(Predicate<String> predicate) {
    for (String item: conversionCRDs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConversionCRD(Predicate<String> predicate) {
    for (String item: conversionCRDs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConversionCRDs(List<String> conversionCRDs) {
    if (conversionCRDs != null) {this.conversionCRDs = new ArrayList(); for (String item : conversionCRDs){this.addToConversionCRDs(item);}} else { this.conversionCRDs = null;} return (A) this;
  }
  public A withConversionCRDs(java.lang.String... conversionCRDs) {
    if (this.conversionCRDs != null) {this.conversionCRDs.clear(); _visitables.remove("conversionCRDs"); }
    if (conversionCRDs != null) {for (String item :conversionCRDs){ this.addToConversionCRDs(item);}} return (A) this;
  }
  public Boolean hasConversionCRDs() {
    return conversionCRDs != null && !conversionCRDs.isEmpty();
  }
  public String getDeploymentName() {
    return this.deploymentName;
  }
  public A withDeploymentName(String deploymentName) {
    this.deploymentName=deploymentName; return (A) this;
  }
  public Boolean hasDeploymentName() {
    return this.deploymentName != null;
  }
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  public Boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  public String getGenerateName() {
    return this.generateName;
  }
  public A withGenerateName(String generateName) {
    this.generateName=generateName; return (A) this;
  }
  public Boolean hasGenerateName() {
    return this.generateName != null;
  }
  public String getMatchPolicy() {
    return this.matchPolicy;
  }
  public A withMatchPolicy(String matchPolicy) {
    this.matchPolicy=matchPolicy; return (A) this;
  }
  public Boolean hasMatchPolicy() {
    return this.matchPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildObjectSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public LabelSelector buildObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public A withObjectSelector(LabelSelector objectSelector) {
    _visitables.get("objectSelector").remove(this.objectSelector);
    if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} else { this.objectSelector = null; _visitables.get("objectSelector").remove(this.objectSelector); } return (A) this;
  }
  public Boolean hasObjectSelector() {
    return this.objectSelector != null;
  }
  public WebhookDescriptionFluentImpl.ObjectSelectorNested<A> withNewObjectSelector() {
    return new WebhookDescriptionFluentImpl.ObjectSelectorNestedImpl();
  }
  public WebhookDescriptionFluentImpl.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
    return new WebhookDescriptionFluentImpl.ObjectSelectorNestedImpl(item);
  }
  public WebhookDescriptionFluentImpl.ObjectSelectorNested<A> editObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector());
  }
  public WebhookDescriptionFluentImpl.ObjectSelectorNested<A> editOrNewObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
  }
  public WebhookDescriptionFluentImpl.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
  }
  public String getReinvocationPolicy() {
    return this.reinvocationPolicy;
  }
  public A withReinvocationPolicy(String reinvocationPolicy) {
    this.reinvocationPolicy=reinvocationPolicy; return (A) this;
  }
  public Boolean hasReinvocationPolicy() {
    return this.reinvocationPolicy != null;
  }
  public A addToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
    this.rules.add(index, item);
    return (A)this;
  }
  public A setToRules(int index,RuleWithOperations item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
    this.rules.set(index, item); return (A)this;
  }
  public A addToRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
    for (RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
  }
  public A addAllToRules(Collection<RuleWithOperations> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleWithOperations>();}
    for (RuleWithOperations item : items) {this.rules.add(item);} return (A)this;
  }
  public A removeFromRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... items) {
    for (RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
  }
  public A removeAllFromRules(Collection<RuleWithOperations> items) {
    for (RuleWithOperations item : items) {if (this.rules!= null){ this.rules.remove(item);}} return (A)this;
  }
  public List<RuleWithOperations> getRules() {
    return this.rules;
  }
  public RuleWithOperations getRule(int index) {
    return this.rules.get(index);
  }
  public RuleWithOperations getFirstRule() {
    return this.rules.get(0);
  }
  public RuleWithOperations getLastRule() {
    return this.rules.get(rules.size() - 1);
  }
  public RuleWithOperations getMatchingRule(Predicate<RuleWithOperations> predicate) {
    for (RuleWithOperations item: rules) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRule(Predicate<RuleWithOperations> predicate) {
    for (RuleWithOperations item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<RuleWithOperations> rules) {
    if (rules != null) {this.rules = new ArrayList(); for (RuleWithOperations item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.kubernetes.api.model.admissionregistration.v1.RuleWithOperations... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (RuleWithOperations item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public String getSideEffects() {
    return this.sideEffects;
  }
  public A withSideEffects(String sideEffects) {
    this.sideEffects=sideEffects; return (A) this;
  }
  public Boolean hasSideEffects() {
    return this.sideEffects != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTargetPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public IntOrString buildTargetPort() {
    return this.targetPort!=null ?this.targetPort.build():null;
  }
  public A withTargetPort(IntOrString targetPort) {
    _visitables.get("targetPort").remove(this.targetPort);
    if (targetPort!=null){ this.targetPort= new IntOrStringBuilder(targetPort); _visitables.get("targetPort").add(this.targetPort);} else { this.targetPort = null; _visitables.get("targetPort").remove(this.targetPort); } return (A) this;
  }
  public Boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public A withNewTargetPort(Object value) {
    return (A)withTargetPort(new IntOrString(value));
  }
  public WebhookDescriptionFluentImpl.TargetPortNested<A> withNewTargetPort() {
    return new WebhookDescriptionFluentImpl.TargetPortNestedImpl();
  }
  public WebhookDescriptionFluentImpl.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
    return new WebhookDescriptionFluentImpl.TargetPortNestedImpl(item);
  }
  public WebhookDescriptionFluentImpl.TargetPortNested<A> editTargetPort() {
    return withNewTargetPortLike(getTargetPort());
  }
  public WebhookDescriptionFluentImpl.TargetPortNested<A> editOrNewTargetPort() {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): new IntOrStringBuilder().build());
  }
  public WebhookDescriptionFluentImpl.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
    return withNewTargetPortLike(getTargetPort() != null ? getTargetPort(): item);
  }
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds=timeoutSeconds; return (A) this;
  }
  public Boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public String getWebhookPath() {
    return this.webhookPath;
  }
  public A withWebhookPath(String webhookPath) {
    this.webhookPath=webhookPath; return (A) this;
  }
  public Boolean hasWebhookPath() {
    return this.webhookPath != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebhookDescriptionFluentImpl that = (WebhookDescriptionFluentImpl) o;
    if (!java.util.Objects.equals(admissionReviewVersions, that.admissionReviewVersions)) return false;

    if (!java.util.Objects.equals(containerPort, that.containerPort)) return false;

    if (!java.util.Objects.equals(conversionCRDs, that.conversionCRDs)) return false;

    if (!java.util.Objects.equals(deploymentName, that.deploymentName)) return false;

    if (!java.util.Objects.equals(failurePolicy, that.failurePolicy)) return false;

    if (!java.util.Objects.equals(generateName, that.generateName)) return false;

    if (!java.util.Objects.equals(matchPolicy, that.matchPolicy)) return false;

    if (!java.util.Objects.equals(objectSelector, that.objectSelector)) return false;

    if (!java.util.Objects.equals(reinvocationPolicy, that.reinvocationPolicy)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(sideEffects, that.sideEffects)) return false;

    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;

    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(webhookPath, that.webhookPath)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(admissionReviewVersions,  containerPort,  conversionCRDs,  deploymentName,  failurePolicy,  generateName,  matchPolicy,  objectSelector,  reinvocationPolicy,  rules,  sideEffects,  targetPort,  timeoutSeconds,  type,  webhookPath,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (admissionReviewVersions != null && !admissionReviewVersions.isEmpty()) { sb.append("admissionReviewVersions:"); sb.append(admissionReviewVersions + ","); }
    if (containerPort != null) { sb.append("containerPort:"); sb.append(containerPort + ","); }
    if (conversionCRDs != null && !conversionCRDs.isEmpty()) { sb.append("conversionCRDs:"); sb.append(conversionCRDs + ","); }
    if (deploymentName != null) { sb.append("deploymentName:"); sb.append(deploymentName + ","); }
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (generateName != null) { sb.append("generateName:"); sb.append(generateName + ","); }
    if (matchPolicy != null) { sb.append("matchPolicy:"); sb.append(matchPolicy + ","); }
    if (objectSelector != null) { sb.append("objectSelector:"); sb.append(objectSelector + ","); }
    if (reinvocationPolicy != null) { sb.append("reinvocationPolicy:"); sb.append(reinvocationPolicy + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules + ","); }
    if (sideEffects != null) { sb.append("sideEffects:"); sb.append(sideEffects + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (webhookPath != null) { sb.append("webhookPath:"); sb.append(webhookPath + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<WebhookDescriptionFluentImpl.ObjectSelectorNested<N>> implements WebhookDescriptionFluentImpl.ObjectSelectorNested<N>,Nested<N>{
    ObjectSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ObjectSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) WebhookDescriptionFluentImpl.this.withObjectSelector(builder.build());
    }
    public N endObjectSelector() {
      return and();
    }
    
  }
  class TargetPortNestedImpl<N> extends IntOrStringFluentImpl<WebhookDescriptionFluentImpl.TargetPortNested<N>> implements WebhookDescriptionFluentImpl.TargetPortNested<N>,Nested<N>{
    TargetPortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    TargetPortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) WebhookDescriptionFluentImpl.this.withTargetPort(builder.build());
    }
    public N endTargetPort() {
      return and();
    }
    
  }
  
}