package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NamedInstallStrategyBuilder extends NamedInstallStrategyFluentImpl<NamedInstallStrategyBuilder> implements VisitableBuilder<NamedInstallStrategy,NamedInstallStrategyBuilder>{
  public NamedInstallStrategyBuilder() {
    this(false);
  }
  public NamedInstallStrategyBuilder(Boolean validationEnabled) {
    this(new NamedInstallStrategy(), validationEnabled);
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NamedInstallStrategy(), validationEnabled);
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,NamedInstallStrategy instance) {
    this(fluent, instance, false);
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategyFluent<?> fluent,NamedInstallStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withSpec(instance.getSpec());
      fluent.withStrategy(instance.getStrategy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategy instance) {
    this(instance,false);
  }
  public NamedInstallStrategyBuilder(NamedInstallStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withSpec(instance.getSpec());
      this.withStrategy(instance.getStrategy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NamedInstallStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public NamedInstallStrategy build() {
    NamedInstallStrategy buildable = new NamedInstallStrategy(fluent.getSpec(),fluent.getStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}