package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InstallPlanStatusFluentImpl<A extends InstallPlanStatusFluent<A>> extends BaseFluent<A> implements InstallPlanStatusFluent<A>{
  public InstallPlanStatusFluentImpl() {
  }
  public InstallPlanStatusFluentImpl(InstallPlanStatus instance) {
    if (instance != null) {
      this.withAttenuatedServiceAccountRef(instance.getAttenuatedServiceAccountRef());
      this.withBundleLookups(instance.getBundleLookups());
      this.withCatalogSources(instance.getCatalogSources());
      this.withConditions(instance.getConditions());
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withPlan(instance.getPlan());
      this.withStartTime(instance.getStartTime());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ObjectReferenceBuilder attenuatedServiceAccountRef;
  private ArrayList<BundleLookupBuilder> bundleLookups = new ArrayList<BundleLookupBuilder>();
  private List<String> catalogSources = new ArrayList<String>();
  private ArrayList<InstallPlanConditionBuilder> conditions = new ArrayList<InstallPlanConditionBuilder>();
  private String message;
  private String phase;
  private ArrayList<StepBuilder> plan = new ArrayList<StepBuilder>();
  private String startTime;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildAttenuatedServiceAccountRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getAttenuatedServiceAccountRef() {
    return this.attenuatedServiceAccountRef!=null ?this.attenuatedServiceAccountRef.build():null;
  }
  public ObjectReference buildAttenuatedServiceAccountRef() {
    return this.attenuatedServiceAccountRef!=null ?this.attenuatedServiceAccountRef.build():null;
  }
  public A withAttenuatedServiceAccountRef(ObjectReference attenuatedServiceAccountRef) {
    _visitables.get("attenuatedServiceAccountRef").remove(this.attenuatedServiceAccountRef);
    if (attenuatedServiceAccountRef!=null){ this.attenuatedServiceAccountRef= new ObjectReferenceBuilder(attenuatedServiceAccountRef); _visitables.get("attenuatedServiceAccountRef").add(this.attenuatedServiceAccountRef);} else { this.attenuatedServiceAccountRef = null; _visitables.get("attenuatedServiceAccountRef").remove(this.attenuatedServiceAccountRef); } return (A) this;
  }
  public Boolean hasAttenuatedServiceAccountRef() {
    return this.attenuatedServiceAccountRef != null;
  }
  public InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRef() {
    return new InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNestedImpl();
  }
  public InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<A> withNewAttenuatedServiceAccountRefLike(ObjectReference item) {
    return new InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNestedImpl(item);
  }
  public InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<A> editAttenuatedServiceAccountRef() {
    return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef());
  }
  public InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRef() {
    return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef() != null ? getAttenuatedServiceAccountRef(): new ObjectReferenceBuilder().build());
  }
  public InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<A> editOrNewAttenuatedServiceAccountRefLike(ObjectReference item) {
    return withNewAttenuatedServiceAccountRefLike(getAttenuatedServiceAccountRef() != null ? getAttenuatedServiceAccountRef(): item);
  }
  public A addToBundleLookups(int index,BundleLookup item) {
    if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
    BundleLookupBuilder builder = new BundleLookupBuilder(item);
    if (index < 0 || index >= bundleLookups.size()) { _visitables.get("bundleLookups").add(builder); bundleLookups.add(builder); } else { _visitables.get("bundleLookups").add(index, builder); bundleLookups.add(index, builder);}
    return (A)this;
  }
  public A setToBundleLookups(int index,BundleLookup item) {
    if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
    BundleLookupBuilder builder = new BundleLookupBuilder(item);
    if (index < 0 || index >= bundleLookups.size()) { _visitables.get("bundleLookups").add(builder); bundleLookups.add(builder); } else { _visitables.get("bundleLookups").set(index, builder); bundleLookups.set(index, builder);}
    return (A)this;
  }
  public A addToBundleLookups(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup... items) {
    if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
    for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").add(builder);this.bundleLookups.add(builder);} return (A)this;
  }
  public A addAllToBundleLookups(Collection<BundleLookup> items) {
    if (this.bundleLookups == null) {this.bundleLookups = new ArrayList<BundleLookupBuilder>();}
    for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").add(builder);this.bundleLookups.add(builder);} return (A)this;
  }
  public A removeFromBundleLookups(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup... items) {
    for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").remove(builder);if (this.bundleLookups != null) {this.bundleLookups.remove(builder);}} return (A)this;
  }
  public A removeAllFromBundleLookups(Collection<BundleLookup> items) {
    for (BundleLookup item : items) {BundleLookupBuilder builder = new BundleLookupBuilder(item);_visitables.get("bundleLookups").remove(builder);if (this.bundleLookups != null) {this.bundleLookups.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBundleLookups(Predicate<BundleLookupBuilder> predicate) {
    if (bundleLookups == null) return (A) this;
    final Iterator<BundleLookupBuilder> each = bundleLookups.iterator();
    final List visitables = _visitables.get("bundleLookups");
    while (each.hasNext()) {
      BundleLookupBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBundleLookups instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BundleLookup> getBundleLookups() {
    return bundleLookups != null ? build(bundleLookups) : null;
  }
  public List<BundleLookup> buildBundleLookups() {
    return bundleLookups != null ? build(bundleLookups) : null;
  }
  public BundleLookup buildBundleLookup(int index) {
    return this.bundleLookups.get(index).build();
  }
  public BundleLookup buildFirstBundleLookup() {
    return this.bundleLookups.get(0).build();
  }
  public BundleLookup buildLastBundleLookup() {
    return this.bundleLookups.get(bundleLookups.size() - 1).build();
  }
  public BundleLookup buildMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
    for (BundleLookupBuilder item: bundleLookups) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
    for (BundleLookupBuilder item: bundleLookups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBundleLookups(List<BundleLookup> bundleLookups) {
    if (this.bundleLookups != null) { _visitables.get("bundleLookups").clear();}
    if (bundleLookups != null) {this.bundleLookups = new ArrayList(); for (BundleLookup item : bundleLookups){this.addToBundleLookups(item);}} else { this.bundleLookups = null;} return (A) this;
  }
  public A withBundleLookups(io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup... bundleLookups) {
    if (this.bundleLookups != null) {this.bundleLookups.clear(); _visitables.remove("bundleLookups"); }
    if (bundleLookups != null) {for (BundleLookup item :bundleLookups){ this.addToBundleLookups(item);}} return (A) this;
  }
  public Boolean hasBundleLookups() {
    return bundleLookups != null && !bundleLookups.isEmpty();
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> addNewBundleLookup() {
    return new InstallPlanStatusFluentImpl.BundleLookupsNestedImpl();
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> addNewBundleLookupLike(BundleLookup item) {
    return new InstallPlanStatusFluentImpl.BundleLookupsNestedImpl(-1, item);
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> setNewBundleLookupLike(int index,BundleLookup item) {
    return new InstallPlanStatusFluentImpl.BundleLookupsNestedImpl(index, item);
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> editBundleLookup(int index) {
    if (bundleLookups.size() <= index) throw new RuntimeException("Can't edit bundleLookups. Index exceeds size.");
    return setNewBundleLookupLike(index, buildBundleLookup(index));
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> editFirstBundleLookup() {
    if (bundleLookups.size() == 0) throw new RuntimeException("Can't edit first bundleLookups. The list is empty.");
    return setNewBundleLookupLike(0, buildBundleLookup(0));
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> editLastBundleLookup() {
    int index = bundleLookups.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last bundleLookups. The list is empty.");
    return setNewBundleLookupLike(index, buildBundleLookup(index));
  }
  public InstallPlanStatusFluentImpl.BundleLookupsNested<A> editMatchingBundleLookup(Predicate<BundleLookupBuilder> predicate) {
    int index = -1;
    for (int i=0;i<bundleLookups.size();i++) { 
    if (predicate.test(bundleLookups.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching bundleLookups. No match found.");
    return setNewBundleLookupLike(index, buildBundleLookup(index));
  }
  public A addToCatalogSources(int index,String item) {
    if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
    this.catalogSources.add(index, item);
    return (A)this;
  }
  public A setToCatalogSources(int index,String item) {
    if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
    this.catalogSources.set(index, item); return (A)this;
  }
  public A addToCatalogSources(java.lang.String... items) {
    if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
    for (String item : items) {this.catalogSources.add(item);} return (A)this;
  }
  public A addAllToCatalogSources(Collection<String> items) {
    if (this.catalogSources == null) {this.catalogSources = new ArrayList<String>();}
    for (String item : items) {this.catalogSources.add(item);} return (A)this;
  }
  public A removeFromCatalogSources(java.lang.String... items) {
    for (String item : items) {if (this.catalogSources!= null){ this.catalogSources.remove(item);}} return (A)this;
  }
  public A removeAllFromCatalogSources(Collection<String> items) {
    for (String item : items) {if (this.catalogSources!= null){ this.catalogSources.remove(item);}} return (A)this;
  }
  public List<String> getCatalogSources() {
    return this.catalogSources;
  }
  public String getCatalogSource(int index) {
    return this.catalogSources.get(index);
  }
  public String getFirstCatalogSource() {
    return this.catalogSources.get(0);
  }
  public String getLastCatalogSource() {
    return this.catalogSources.get(catalogSources.size() - 1);
  }
  public String getMatchingCatalogSource(Predicate<String> predicate) {
    for (String item: catalogSources) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCatalogSource(Predicate<String> predicate) {
    for (String item: catalogSources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCatalogSources(List<String> catalogSources) {
    if (catalogSources != null) {this.catalogSources = new ArrayList(); for (String item : catalogSources){this.addToCatalogSources(item);}} else { this.catalogSources = null;} return (A) this;
  }
  public A withCatalogSources(java.lang.String... catalogSources) {
    if (this.catalogSources != null) {this.catalogSources.clear(); _visitables.remove("catalogSources"); }
    if (catalogSources != null) {for (String item :catalogSources){ this.addToCatalogSources(item);}} return (A) this;
  }
  public Boolean hasCatalogSources() {
    return catalogSources != null && !catalogSources.isEmpty();
  }
  public A addToConditions(int index,InstallPlanCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
    InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,InstallPlanCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
    InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
    for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<InstallPlanCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<InstallPlanConditionBuilder>();}
    for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanCondition... items) {
    for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<InstallPlanCondition> items) {
    for (InstallPlanCondition item : items) {InstallPlanConditionBuilder builder = new InstallPlanConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<InstallPlanConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<InstallPlanConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      InstallPlanConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<InstallPlanCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<InstallPlanCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public InstallPlanCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public InstallPlanCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public InstallPlanCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public InstallPlanCondition buildMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
    for (InstallPlanConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
    for (InstallPlanConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<InstallPlanCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (InstallPlanCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (InstallPlanCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new InstallPlanStatusFluentImpl.ConditionsNestedImpl();
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> addNewConditionLike(InstallPlanCondition item) {
    return new InstallPlanStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,InstallPlanCondition item) {
    return new InstallPlanStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public InstallPlanStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<InstallPlanConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public String getMessage() {
    return this.message;
  }
  public A withMessage(String message) {
    this.message=message; return (A) this;
  }
  public Boolean hasMessage() {
    return this.message != null;
  }
  public String getPhase() {
    return this.phase;
  }
  public A withPhase(String phase) {
    this.phase=phase; return (A) this;
  }
  public Boolean hasPhase() {
    return this.phase != null;
  }
  public A addToPlan(int index,Step item) {
    if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
    StepBuilder builder = new StepBuilder(item);
    if (index < 0 || index >= plan.size()) { _visitables.get("plan").add(builder); plan.add(builder); } else { _visitables.get("plan").add(index, builder); plan.add(index, builder);}
    return (A)this;
  }
  public A setToPlan(int index,Step item) {
    if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
    StepBuilder builder = new StepBuilder(item);
    if (index < 0 || index >= plan.size()) { _visitables.get("plan").add(builder); plan.add(builder); } else { _visitables.get("plan").set(index, builder); plan.set(index, builder);}
    return (A)this;
  }
  public A addToPlan(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Step... items) {
    if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").add(builder);this.plan.add(builder);} return (A)this;
  }
  public A addAllToPlan(Collection<Step> items) {
    if (this.plan == null) {this.plan = new ArrayList<StepBuilder>();}
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").add(builder);this.plan.add(builder);} return (A)this;
  }
  public A removeFromPlan(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Step... items) {
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").remove(builder);if (this.plan != null) {this.plan.remove(builder);}} return (A)this;
  }
  public A removeAllFromPlan(Collection<Step> items) {
    for (Step item : items) {StepBuilder builder = new StepBuilder(item);_visitables.get("plan").remove(builder);if (this.plan != null) {this.plan.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPlan(Predicate<StepBuilder> predicate) {
    if (plan == null) return (A) this;
    final Iterator<StepBuilder> each = plan.iterator();
    final List visitables = _visitables.get("plan");
    while (each.hasNext()) {
      StepBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPlan instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Step> getPlan() {
    return plan != null ? build(plan) : null;
  }
  public List<Step> buildPlan() {
    return plan != null ? build(plan) : null;
  }
  public Step buildPlan(int index) {
    return this.plan.get(index).build();
  }
  public Step buildFirstPlan() {
    return this.plan.get(0).build();
  }
  public Step buildLastPlan() {
    return this.plan.get(plan.size() - 1).build();
  }
  public Step buildMatchingPlan(Predicate<StepBuilder> predicate) {
    for (StepBuilder item: plan) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPlan(Predicate<StepBuilder> predicate) {
    for (StepBuilder item: plan) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPlan(List<Step> plan) {
    if (this.plan != null) { _visitables.get("plan").clear();}
    if (plan != null) {this.plan = new ArrayList(); for (Step item : plan){this.addToPlan(item);}} else { this.plan = null;} return (A) this;
  }
  public A withPlan(io.fabric8.openshift.api.model.operatorhub.v1alpha1.Step... plan) {
    if (this.plan != null) {this.plan.clear(); _visitables.remove("plan"); }
    if (plan != null) {for (Step item :plan){ this.addToPlan(item);}} return (A) this;
  }
  public Boolean hasPlan() {
    return plan != null && !plan.isEmpty();
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> addNewPlan() {
    return new InstallPlanStatusFluentImpl.PlanNestedImpl();
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> addNewPlanLike(Step item) {
    return new InstallPlanStatusFluentImpl.PlanNestedImpl(-1, item);
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> setNewPlanLike(int index,Step item) {
    return new InstallPlanStatusFluentImpl.PlanNestedImpl(index, item);
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> editPlan(int index) {
    if (plan.size() <= index) throw new RuntimeException("Can't edit plan. Index exceeds size.");
    return setNewPlanLike(index, buildPlan(index));
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> editFirstPlan() {
    if (plan.size() == 0) throw new RuntimeException("Can't edit first plan. The list is empty.");
    return setNewPlanLike(0, buildPlan(0));
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> editLastPlan() {
    int index = plan.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last plan. The list is empty.");
    return setNewPlanLike(index, buildPlan(index));
  }
  public InstallPlanStatusFluentImpl.PlanNested<A> editMatchingPlan(Predicate<StepBuilder> predicate) {
    int index = -1;
    for (int i=0;i<plan.size();i++) { 
    if (predicate.test(plan.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching plan. No match found.");
    return setNewPlanLike(index, buildPlan(index));
  }
  public String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public Boolean hasStartTime() {
    return this.startTime != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InstallPlanStatusFluentImpl that = (InstallPlanStatusFluentImpl) o;
    if (!java.util.Objects.equals(attenuatedServiceAccountRef, that.attenuatedServiceAccountRef)) return false;

    if (!java.util.Objects.equals(bundleLookups, that.bundleLookups)) return false;

    if (!java.util.Objects.equals(catalogSources, that.catalogSources)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(message, that.message)) return false;

    if (!java.util.Objects.equals(phase, that.phase)) return false;

    if (!java.util.Objects.equals(plan, that.plan)) return false;

    if (!java.util.Objects.equals(startTime, that.startTime)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attenuatedServiceAccountRef,  bundleLookups,  catalogSources,  conditions,  message,  phase,  plan,  startTime,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attenuatedServiceAccountRef != null) { sb.append("attenuatedServiceAccountRef:"); sb.append(attenuatedServiceAccountRef + ","); }
    if (bundleLookups != null) { sb.append("bundleLookups:"); sb.append(bundleLookups + ","); }
    if (catalogSources != null && !catalogSources.isEmpty()) { sb.append("catalogSources:"); sb.append(catalogSources + ","); }
    if (conditions != null) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (message != null) { sb.append("message:"); sb.append(message + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (plan != null) { sb.append("plan:"); sb.append(plan + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AttenuatedServiceAccountRefNestedImpl<N> extends ObjectReferenceFluentImpl<InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<N>> implements InstallPlanStatusFluentImpl.AttenuatedServiceAccountRefNested<N>,Nested<N>{
    AttenuatedServiceAccountRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    AttenuatedServiceAccountRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) InstallPlanStatusFluentImpl.this.withAttenuatedServiceAccountRef(builder.build());
    }
    public N endAttenuatedServiceAccountRef() {
      return and();
    }
    
  }
  class BundleLookupsNestedImpl<N> extends BundleLookupFluentImpl<InstallPlanStatusFluentImpl.BundleLookupsNested<N>> implements InstallPlanStatusFluentImpl.BundleLookupsNested<N>,Nested<N>{
    BundleLookupsNestedImpl(int index,BundleLookup item) {
      this.index = index;
      this.builder = new BundleLookupBuilder(this, item);
    }
    BundleLookupsNestedImpl() {
      this.index = -1;
      this.builder = new BundleLookupBuilder(this);
    }
    BundleLookupBuilder builder;
    int index;
    public N and() {
      return (N) InstallPlanStatusFluentImpl.this.setToBundleLookups(index,builder.build());
    }
    public N endBundleLookup() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends InstallPlanConditionFluentImpl<InstallPlanStatusFluentImpl.ConditionsNested<N>> implements InstallPlanStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,InstallPlanCondition item) {
      this.index = index;
      this.builder = new InstallPlanConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new InstallPlanConditionBuilder(this);
    }
    InstallPlanConditionBuilder builder;
    int index;
    public N and() {
      return (N) InstallPlanStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class PlanNestedImpl<N> extends StepFluentImpl<InstallPlanStatusFluentImpl.PlanNested<N>> implements InstallPlanStatusFluentImpl.PlanNested<N>,Nested<N>{
    PlanNestedImpl(int index,Step item) {
      this.index = index;
      this.builder = new StepBuilder(this, item);
    }
    PlanNestedImpl() {
      this.index = -1;
      this.builder = new StepBuilder(this);
    }
    StepBuilder builder;
    int index;
    public N and() {
      return (N) InstallPlanStatusFluentImpl.this.setToPlan(index,builder.build());
    }
    public N endPlan() {
      return and();
    }
    
  }
  
}