package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class InstallPlanSpecFluentImpl<A extends InstallPlanSpecFluent<A>> extends BaseFluent<A> implements InstallPlanSpecFluent<A>{
  public InstallPlanSpecFluentImpl() {
  }
  public InstallPlanSpecFluentImpl(InstallPlanSpec instance) {
    if (instance != null) {
      this.withApproval(instance.getApproval());
      this.withApproved(instance.getApproved());
      this.withClusterServiceVersionNames(instance.getClusterServiceVersionNames());
      this.withGeneration(instance.getGeneration());
      this.withSource(instance.getSource());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String approval;
  private Boolean approved;
  private List<String> clusterServiceVersionNames = new ArrayList<String>();
  private Integer generation;
  private String source;
  private String sourceNamespace;
  private Map<String,Object> additionalProperties;
  public String getApproval() {
    return this.approval;
  }
  public A withApproval(String approval) {
    this.approval=approval; return (A) this;
  }
  public Boolean hasApproval() {
    return this.approval != null;
  }
  public Boolean getApproved() {
    return this.approved;
  }
  public A withApproved(Boolean approved) {
    this.approved=approved; return (A) this;
  }
  public Boolean hasApproved() {
    return this.approved != null;
  }
  public A addToClusterServiceVersionNames(int index,String item) {
    if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
    this.clusterServiceVersionNames.add(index, item);
    return (A)this;
  }
  public A setToClusterServiceVersionNames(int index,String item) {
    if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
    this.clusterServiceVersionNames.set(index, item); return (A)this;
  }
  public A addToClusterServiceVersionNames(java.lang.String... items) {
    if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
    for (String item : items) {this.clusterServiceVersionNames.add(item);} return (A)this;
  }
  public A addAllToClusterServiceVersionNames(Collection<String> items) {
    if (this.clusterServiceVersionNames == null) {this.clusterServiceVersionNames = new ArrayList<String>();}
    for (String item : items) {this.clusterServiceVersionNames.add(item);} return (A)this;
  }
  public A removeFromClusterServiceVersionNames(java.lang.String... items) {
    for (String item : items) {if (this.clusterServiceVersionNames!= null){ this.clusterServiceVersionNames.remove(item);}} return (A)this;
  }
  public A removeAllFromClusterServiceVersionNames(Collection<String> items) {
    for (String item : items) {if (this.clusterServiceVersionNames!= null){ this.clusterServiceVersionNames.remove(item);}} return (A)this;
  }
  public List<String> getClusterServiceVersionNames() {
    return this.clusterServiceVersionNames;
  }
  public String getClusterServiceVersionName(int index) {
    return this.clusterServiceVersionNames.get(index);
  }
  public String getFirstClusterServiceVersionName() {
    return this.clusterServiceVersionNames.get(0);
  }
  public String getLastClusterServiceVersionName() {
    return this.clusterServiceVersionNames.get(clusterServiceVersionNames.size() - 1);
  }
  public String getMatchingClusterServiceVersionName(Predicate<String> predicate) {
    for (String item: clusterServiceVersionNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingClusterServiceVersionName(Predicate<String> predicate) {
    for (String item: clusterServiceVersionNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterServiceVersionNames(List<String> clusterServiceVersionNames) {
    if (clusterServiceVersionNames != null) {this.clusterServiceVersionNames = new ArrayList(); for (String item : clusterServiceVersionNames){this.addToClusterServiceVersionNames(item);}} else { this.clusterServiceVersionNames = null;} return (A) this;
  }
  public A withClusterServiceVersionNames(java.lang.String... clusterServiceVersionNames) {
    if (this.clusterServiceVersionNames != null) {this.clusterServiceVersionNames.clear(); _visitables.remove("clusterServiceVersionNames"); }
    if (clusterServiceVersionNames != null) {for (String item :clusterServiceVersionNames){ this.addToClusterServiceVersionNames(item);}} return (A) this;
  }
  public Boolean hasClusterServiceVersionNames() {
    return clusterServiceVersionNames != null && !clusterServiceVersionNames.isEmpty();
  }
  public Integer getGeneration() {
    return this.generation;
  }
  public A withGeneration(Integer generation) {
    this.generation=generation; return (A) this;
  }
  public Boolean hasGeneration() {
    return this.generation != null;
  }
  public String getSource() {
    return this.source;
  }
  public A withSource(String source) {
    this.source=source; return (A) this;
  }
  public Boolean hasSource() {
    return this.source != null;
  }
  public String getSourceNamespace() {
    return this.sourceNamespace;
  }
  public A withSourceNamespace(String sourceNamespace) {
    this.sourceNamespace=sourceNamespace; return (A) this;
  }
  public Boolean hasSourceNamespace() {
    return this.sourceNamespace != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    InstallPlanSpecFluentImpl that = (InstallPlanSpecFluentImpl) o;
    if (!java.util.Objects.equals(approval, that.approval)) return false;

    if (!java.util.Objects.equals(approved, that.approved)) return false;

    if (!java.util.Objects.equals(clusterServiceVersionNames, that.clusterServiceVersionNames)) return false;

    if (!java.util.Objects.equals(generation, that.generation)) return false;

    if (!java.util.Objects.equals(source, that.source)) return false;

    if (!java.util.Objects.equals(sourceNamespace, that.sourceNamespace)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(approval,  approved,  clusterServiceVersionNames,  generation,  source,  sourceNamespace,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (approval != null) { sb.append("approval:"); sb.append(approval + ","); }
    if (approved != null) { sb.append("approved:"); sb.append(approved + ","); }
    if (clusterServiceVersionNames != null && !clusterServiceVersionNames.isEmpty()) { sb.append("clusterServiceVersionNames:"); sb.append(clusterServiceVersionNames + ","); }
    if (generation != null) { sb.append("generation:"); sb.append(generation + ","); }
    if (source != null) { sb.append("source:"); sb.append(source + ","); }
    if (sourceNamespace != null) { sb.append("sourceNamespace:"); sb.append(sourceNamespace + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withApproved() {
    return withApproved(true);
  }
  
}