package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InstallPlanSpecBuilder extends InstallPlanSpecFluentImpl<InstallPlanSpecBuilder> implements VisitableBuilder<InstallPlanSpec,InstallPlanSpecBuilder>{
  public InstallPlanSpecBuilder() {
    this(false);
  }
  public InstallPlanSpecBuilder(Boolean validationEnabled) {
    this(new InstallPlanSpec(), validationEnabled);
  }
  public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new InstallPlanSpec(), validationEnabled);
  }
  public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,InstallPlanSpec instance) {
    this(fluent, instance, false);
  }
  public InstallPlanSpecBuilder(InstallPlanSpecFluent<?> fluent,InstallPlanSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApproval(instance.getApproval());
      fluent.withApproved(instance.getApproved());
      fluent.withClusterServiceVersionNames(instance.getClusterServiceVersionNames());
      fluent.withGeneration(instance.getGeneration());
      fluent.withSource(instance.getSource());
      fluent.withSourceNamespace(instance.getSourceNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public InstallPlanSpecBuilder(InstallPlanSpec instance) {
    this(instance,false);
  }
  public InstallPlanSpecBuilder(InstallPlanSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApproval(instance.getApproval());
      this.withApproved(instance.getApproved());
      this.withClusterServiceVersionNames(instance.getClusterServiceVersionNames());
      this.withGeneration(instance.getGeneration());
      this.withSource(instance.getSource());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  InstallPlanSpecFluent<?> fluent;
  Boolean validationEnabled;
  public InstallPlanSpec build() {
    InstallPlanSpec buildable = new InstallPlanSpec(fluent.getApproval(),fluent.getApproved(),fluent.getClusterServiceVersionNames(),fluent.getGeneration(),fluent.getSource(),fluent.getSourceNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}