package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCConnectionStateBuilder extends GRPCConnectionStateFluentImpl<GRPCConnectionStateBuilder> implements VisitableBuilder<GRPCConnectionState,GRPCConnectionStateBuilder>{
  public GRPCConnectionStateBuilder() {
    this(false);
  }
  public GRPCConnectionStateBuilder(Boolean validationEnabled) {
    this(new GRPCConnectionState(), validationEnabled);
  }
  public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCConnectionState(), validationEnabled);
  }
  public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,GRPCConnectionState instance) {
    this(fluent, instance, false);
  }
  public GRPCConnectionStateBuilder(GRPCConnectionStateFluent<?> fluent,GRPCConnectionState instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAddress(instance.getAddress());
      fluent.withLastConnect(instance.getLastConnect());
      fluent.withLastObservedState(instance.getLastObservedState());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCConnectionStateBuilder(GRPCConnectionState instance) {
    this(instance,false);
  }
  public GRPCConnectionStateBuilder(GRPCConnectionState instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAddress(instance.getAddress());
      this.withLastConnect(instance.getLastConnect());
      this.withLastObservedState(instance.getLastObservedState());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCConnectionStateFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCConnectionState build() {
    GRPCConnectionState buildable = new GRPCConnectionState(fluent.getAddress(),fluent.getLastConnect(),fluent.getLastObservedState());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}