package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapResourceReferenceBuilder extends ConfigMapResourceReferenceFluentImpl<ConfigMapResourceReferenceBuilder> implements VisitableBuilder<ConfigMapResourceReference,ConfigMapResourceReferenceBuilder>{
  public ConfigMapResourceReferenceBuilder() {
    this(false);
  }
  public ConfigMapResourceReferenceBuilder(Boolean validationEnabled) {
    this(new ConfigMapResourceReference(), validationEnabled);
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConfigMapResourceReference(), validationEnabled);
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReferenceFluent<?> fluent,ConfigMapResourceReference instance) {
    this(fluent, instance, false);
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReferenceFluent<?> fluent,ConfigMapResourceReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastUpdateTime(instance.getLastUpdateTime());
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withResourceVersion(instance.getResourceVersion());
      fluent.withUid(instance.getUid());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReference instance) {
    this(instance,false);
  }
  public ConfigMapResourceReferenceBuilder(ConfigMapResourceReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastUpdateTime(instance.getLastUpdateTime());
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withResourceVersion(instance.getResourceVersion());
      this.withUid(instance.getUid());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ConfigMapResourceReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public ConfigMapResourceReference build() {
    ConfigMapResourceReference buildable = new ConfigMapResourceReference(fluent.getLastUpdateTime(),fluent.getName(),fluent.getNamespace(),fluent.getResourceVersion(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}