package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterServiceVersionBuilder extends ClusterServiceVersionFluentImpl<ClusterServiceVersionBuilder> implements VisitableBuilder<ClusterServiceVersion,ClusterServiceVersionBuilder>{
  public ClusterServiceVersionBuilder() {
    this(false);
  }
  public ClusterServiceVersionBuilder(Boolean validationEnabled) {
    this(new ClusterServiceVersion(), validationEnabled);
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterServiceVersion(), validationEnabled);
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,ClusterServiceVersion instance) {
    this(fluent, instance, false);
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersionFluent<?> fluent,ClusterServiceVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersion instance) {
    this(instance,false);
  }
  public ClusterServiceVersionBuilder(ClusterServiceVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterServiceVersionFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterServiceVersion build() {
    ClusterServiceVersion buildable = new ClusterServiceVersion(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}