package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface CatalogSourceSpecFluent<A extends CatalogSourceSpecFluent<A>> extends Fluent<A>{
  public String getAddress();
  public A withAddress(String address);
  public Boolean hasAddress();
  public String getConfigMap();
  public A withConfigMap(String configMap);
  public Boolean hasConfigMap();
  public String getDescription();
  public A withDescription(String description);
  public Boolean hasDescription();
  public String getDisplayName();
  public A withDisplayName(String displayName);
  public Boolean hasDisplayName();
  
  /**
   * This method has been deprecated, please use method buildIcon instead.
   * @return The buildable object.
   */
  @Deprecated
  public Icon getIcon();
  public Icon buildIcon();
  public A withIcon(Icon icon);
  public Boolean hasIcon();
  public A withNewIcon(String base64data,String mediatype);
  public CatalogSourceSpecFluent.IconNested<A> withNewIcon();
  public CatalogSourceSpecFluent.IconNested<A> withNewIconLike(Icon item);
  public CatalogSourceSpecFluent.IconNested<A> editIcon();
  public CatalogSourceSpecFluent.IconNested<A> editOrNewIcon();
  public CatalogSourceSpecFluent.IconNested<A> editOrNewIconLike(Icon item);
  public String getImage();
  public A withImage(String image);
  public Boolean hasImage();
  public Integer getPriority();
  public A withPriority(Integer priority);
  public Boolean hasPriority();
  public String getPublisher();
  public A withPublisher(String publisher);
  public Boolean hasPublisher();
  public A addToSecrets(int index,String item);
  public A setToSecrets(int index,String item);
  public A addToSecrets(java.lang.String... items);
  public A addAllToSecrets(Collection<String> items);
  public A removeFromSecrets(java.lang.String... items);
  public A removeAllFromSecrets(Collection<String> items);
  public List<String> getSecrets();
  public String getSecret(int index);
  public String getFirstSecret();
  public String getLastSecret();
  public String getMatchingSecret(Predicate<String> predicate);
  public Boolean hasMatchingSecret(Predicate<String> predicate);
  public A withSecrets(List<String> secrets);
  public A withSecrets(java.lang.String... secrets);
  public Boolean hasSecrets();
  public String getSourceType();
  public A withSourceType(String sourceType);
  public Boolean hasSourceType();
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public UpdateStrategy getUpdateStrategy();
  public UpdateStrategy buildUpdateStrategy();
  public A withUpdateStrategy(UpdateStrategy updateStrategy);
  public Boolean hasUpdateStrategy();
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(UpdateStrategy item);
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
  public CatalogSourceSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(UpdateStrategy item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface IconNested<N> extends Nested<N>,IconFluent<CatalogSourceSpecFluent.IconNested<N>>{
    public N and();
    public N endIcon();
    
  }
  public interface UpdateStrategyNested<N> extends Nested<N>,UpdateStrategyFluent<CatalogSourceSpecFluent.UpdateStrategyNested<N>>{
    public N and();
    public N endUpdateStrategy();
    
  }
  
}