package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorSpecBuilder extends OperatorSpecFluentImpl<OperatorSpecBuilder> implements VisitableBuilder<OperatorSpec,OperatorSpecBuilder>{
  public OperatorSpecBuilder() {
    this(false);
  }
  public OperatorSpecBuilder(Boolean validationEnabled) {
    this(new OperatorSpec(), validationEnabled);
  }
  public OperatorSpecBuilder(OperatorSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorSpecBuilder(OperatorSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorSpec(), validationEnabled);
  }
  public OperatorSpecBuilder(OperatorSpecFluent<?> fluent,OperatorSpec instance) {
    this(fluent, instance, false);
  }
  public OperatorSpecBuilder(OperatorSpecFluent<?> fluent,OperatorSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorSpecBuilder(OperatorSpec instance) {
    this(instance,false);
  }
  public OperatorSpecBuilder(OperatorSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorSpecFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorSpec build() {
    OperatorSpec buildable = new OperatorSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}