package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorGroupStatusBuilder extends OperatorGroupStatusFluentImpl<OperatorGroupStatusBuilder> implements VisitableBuilder<OperatorGroupStatus,OperatorGroupStatusBuilder>{
  public OperatorGroupStatusBuilder() {
    this(false);
  }
  public OperatorGroupStatusBuilder(Boolean validationEnabled) {
    this(new OperatorGroupStatus(), validationEnabled);
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorGroupStatus(), validationEnabled);
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatusFluent<?> fluent,OperatorGroupStatus instance) {
    this(fluent, instance, false);
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatusFluent<?> fluent,OperatorGroupStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withLastUpdated(instance.getLastUpdated());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withServiceAccountRef(instance.getServiceAccountRef());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatus instance) {
    this(instance,false);
  }
  public OperatorGroupStatusBuilder(OperatorGroupStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withLastUpdated(instance.getLastUpdated());
      this.withNamespaces(instance.getNamespaces());
      this.withServiceAccountRef(instance.getServiceAccountRef());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  OperatorGroupStatusFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorGroupStatus build() {
    OperatorGroupStatus buildable = new OperatorGroupStatus(fluent.getConditions(),fluent.getLastUpdated(),fluent.getNamespaces(),fluent.getServiceAccountRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}