package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ComponentsFluentImpl<A extends ComponentsFluent<A>> extends BaseFluent<A> implements ComponentsFluent<A>{
  public ComponentsFluentImpl() {
  }
  public ComponentsFluentImpl(Components instance) {
    if (instance != null) {
      this.withLabelSelector(instance.getLabelSelector());
      this.withRefs(instance.getRefs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private LabelSelectorBuilder labelSelector;
  private List<JsonNode> refs = new ArrayList<JsonNode>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildLabelSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public LabelSelector buildLabelSelector() {
    return this.labelSelector!=null ?this.labelSelector.build():null;
  }
  public A withLabelSelector(LabelSelector labelSelector) {
    _visitables.get("labelSelector").remove(this.labelSelector);
    if (labelSelector!=null){ this.labelSelector= new LabelSelectorBuilder(labelSelector); _visitables.get("labelSelector").add(this.labelSelector);} else { this.labelSelector = null; _visitables.get("labelSelector").remove(this.labelSelector); } return (A) this;
  }
  public Boolean hasLabelSelector() {
    return this.labelSelector != null;
  }
  public ComponentsFluentImpl.LabelSelectorNested<A> withNewLabelSelector() {
    return new ComponentsFluentImpl.LabelSelectorNestedImpl();
  }
  public ComponentsFluentImpl.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
    return new ComponentsFluentImpl.LabelSelectorNestedImpl(item);
  }
  public ComponentsFluentImpl.LabelSelectorNested<A> editLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector());
  }
  public ComponentsFluentImpl.LabelSelectorNested<A> editOrNewLabelSelector() {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): new LabelSelectorBuilder().build());
  }
  public ComponentsFluentImpl.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
    return withNewLabelSelectorLike(getLabelSelector() != null ? getLabelSelector(): item);
  }
  public A addToRefs(int index,JsonNode item) {
    if (this.refs == null) {this.refs = new ArrayList<JsonNode>();}
    this.refs.add(index, item);
    return (A)this;
  }
  public A setToRefs(int index,JsonNode item) {
    if (this.refs == null) {this.refs = new ArrayList<JsonNode>();}
    this.refs.set(index, item); return (A)this;
  }
  public A addToRefs(com.fasterxml.jackson.databind.JsonNode... items) {
    if (this.refs == null) {this.refs = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.refs.add(item);} return (A)this;
  }
  public A addAllToRefs(Collection<JsonNode> items) {
    if (this.refs == null) {this.refs = new ArrayList<JsonNode>();}
    for (JsonNode item : items) {this.refs.add(item);} return (A)this;
  }
  public A removeFromRefs(com.fasterxml.jackson.databind.JsonNode... items) {
    for (JsonNode item : items) {if (this.refs!= null){ this.refs.remove(item);}} return (A)this;
  }
  public A removeAllFromRefs(Collection<JsonNode> items) {
    for (JsonNode item : items) {if (this.refs!= null){ this.refs.remove(item);}} return (A)this;
  }
  public List<JsonNode> getRefs() {
    return this.refs;
  }
  public JsonNode getRef(int index) {
    return this.refs.get(index);
  }
  public JsonNode getFirstRef() {
    return this.refs.get(0);
  }
  public JsonNode getLastRef() {
    return this.refs.get(refs.size() - 1);
  }
  public JsonNode getMatchingRef(Predicate<JsonNode> predicate) {
    for (JsonNode item: refs) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRef(Predicate<JsonNode> predicate) {
    for (JsonNode item: refs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRefs(List<JsonNode> refs) {
    if (refs != null) {this.refs = new ArrayList(); for (JsonNode item : refs){this.addToRefs(item);}} else { this.refs = null;} return (A) this;
  }
  public A withRefs(com.fasterxml.jackson.databind.JsonNode... refs) {
    if (this.refs != null) {this.refs.clear(); _visitables.remove("refs"); }
    if (refs != null) {for (JsonNode item :refs){ this.addToRefs(item);}} return (A) this;
  }
  public Boolean hasRefs() {
    return refs != null && !refs.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ComponentsFluentImpl that = (ComponentsFluentImpl) o;
    if (!java.util.Objects.equals(labelSelector, that.labelSelector)) return false;

    if (!java.util.Objects.equals(refs, that.refs)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(labelSelector,  refs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labelSelector != null) { sb.append("labelSelector:"); sb.append(labelSelector + ","); }
    if (refs != null && !refs.isEmpty()) { sb.append("refs:"); sb.append(refs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class LabelSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ComponentsFluentImpl.LabelSelectorNested<N>> implements ComponentsFluentImpl.LabelSelectorNested<N>,Nested<N>{
    LabelSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ComponentsFluentImpl.this.withLabelSelector(builder.build());
    }
    public N endLabelSelector() {
      return and();
    }
    
  }
  
}