package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallModeBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitions;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitionsFluentImpl;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitions;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.APIServiceDefinitionsBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import java.lang.Deprecated;
import java.util.Iterator;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitionsFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.CustomResourceDefinitionsBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallModeFluentImpl;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CSVDescriptionFluentImpl<A extends CSVDescriptionFluent<A>> extends BaseFluent<A> implements CSVDescriptionFluent<A>{
  public CSVDescriptionFluentImpl() {
  }
  public CSVDescriptionFluentImpl(CSVDescription instance) {
    if (instance != null) {
      this.withAnnotations(instance.getAnnotations());
      this.withApiservicedefinitions(instance.getApiservicedefinitions());
      this.withCustomresourcedefinitions(instance.getCustomresourcedefinitions());
      this.withDescription(instance.getDescription());
      this.withDisplayName(instance.getDisplayName());
      this.withIcon(instance.getIcon());
      this.withInstallModes(instance.getInstallModes());
      this.withKeywords(instance.getKeywords());
      this.withLinks(instance.getLinks());
      this.withMaintainers(instance.getMaintainers());
      this.withMaturity(instance.getMaturity());
      this.withMinKubeVersion(instance.getMinKubeVersion());
      this.withNativeApis(instance.getNativeApis());
      this.withProvider(instance.getProvider());
      this.withRelatedImages(instance.getRelatedImages());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Map<String,String> annotations;
  private APIServiceDefinitionsBuilder apiservicedefinitions;
  private CustomResourceDefinitionsBuilder customresourcedefinitions;
  private String description;
  private String displayName;
  private ArrayList<IconBuilder> icon = new ArrayList<IconBuilder>();
  private ArrayList<InstallModeBuilder> installModes = new ArrayList<InstallModeBuilder>();
  private List<String> keywords = new ArrayList<String>();
  private ArrayList<AppLinkBuilder> links = new ArrayList<AppLinkBuilder>();
  private ArrayList<MaintainerBuilder> maintainers = new ArrayList<MaintainerBuilder>();
  private String maturity;
  private String minKubeVersion;
  private List<GroupVersionKind> nativeApis = new ArrayList<GroupVersionKind>();
  private AppLinkBuilder provider;
  private List<String> relatedImages = new ArrayList<String>();
  private String version;
  private Map<String,Object> additionalProperties;
  public A addToAnnotations(String key,String value) {
    if(this.annotations == null && key != null && value != null) { this.annotations = new LinkedHashMap(); }
    if(key != null && value != null) {this.annotations.put(key, value);} return (A)this;
  }
  public A addToAnnotations(Map<String,String> map) {
    if(this.annotations == null && map != null) { this.annotations = new LinkedHashMap(); }
    if(map != null) { this.annotations.putAll(map);} return (A)this;
  }
  public A removeFromAnnotations(String key) {
    if(this.annotations == null) { return (A) this; }
    if(key != null && this.annotations != null) {this.annotations.remove(key);} return (A)this;
  }
  public A removeFromAnnotations(Map<String,String> map) {
    if(this.annotations == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.annotations != null){this.annotations.remove(key);}}} return (A)this;
  }
  public Map<String,String> getAnnotations() {
    return this.annotations;
  }
  public <K,V>A withAnnotations(Map<String,String> annotations) {
    if (annotations == null) { this.annotations =  null;} else {this.annotations = new LinkedHashMap(annotations);} return (A) this;
  }
  public Boolean hasAnnotations() {
    return this.annotations != null;
  }
  
  /**
   * This method has been deprecated, please use method buildApiservicedefinitions instead.
   * @return The buildable object.
   */
  @Deprecated
  public APIServiceDefinitions getApiservicedefinitions() {
    return this.apiservicedefinitions!=null ?this.apiservicedefinitions.build():null;
  }
  public APIServiceDefinitions buildApiservicedefinitions() {
    return this.apiservicedefinitions!=null ?this.apiservicedefinitions.build():null;
  }
  public A withApiservicedefinitions(APIServiceDefinitions apiservicedefinitions) {
    _visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions);
    if (apiservicedefinitions!=null){ this.apiservicedefinitions= new APIServiceDefinitionsBuilder(apiservicedefinitions); _visitables.get("apiservicedefinitions").add(this.apiservicedefinitions);} else { this.apiservicedefinitions = null; _visitables.get("apiservicedefinitions").remove(this.apiservicedefinitions); } return (A) this;
  }
  public Boolean hasApiservicedefinitions() {
    return this.apiservicedefinitions != null;
  }
  public CSVDescriptionFluentImpl.ApiservicedefinitionsNested<A> withNewApiservicedefinitions() {
    return new CSVDescriptionFluentImpl.ApiservicedefinitionsNestedImpl();
  }
  public CSVDescriptionFluentImpl.ApiservicedefinitionsNested<A> withNewApiservicedefinitionsLike(APIServiceDefinitions item) {
    return new CSVDescriptionFluentImpl.ApiservicedefinitionsNestedImpl(item);
  }
  public CSVDescriptionFluentImpl.ApiservicedefinitionsNested<A> editApiservicedefinitions() {
    return withNewApiservicedefinitionsLike(getApiservicedefinitions());
  }
  public CSVDescriptionFluentImpl.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitions() {
    return withNewApiservicedefinitionsLike(getApiservicedefinitions() != null ? getApiservicedefinitions(): new APIServiceDefinitionsBuilder().build());
  }
  public CSVDescriptionFluentImpl.ApiservicedefinitionsNested<A> editOrNewApiservicedefinitionsLike(APIServiceDefinitions item) {
    return withNewApiservicedefinitionsLike(getApiservicedefinitions() != null ? getApiservicedefinitions(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCustomresourcedefinitions instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceDefinitions getCustomresourcedefinitions() {
    return this.customresourcedefinitions!=null ?this.customresourcedefinitions.build():null;
  }
  public CustomResourceDefinitions buildCustomresourcedefinitions() {
    return this.customresourcedefinitions!=null ?this.customresourcedefinitions.build():null;
  }
  public A withCustomresourcedefinitions(CustomResourceDefinitions customresourcedefinitions) {
    _visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions);
    if (customresourcedefinitions!=null){ this.customresourcedefinitions= new CustomResourceDefinitionsBuilder(customresourcedefinitions); _visitables.get("customresourcedefinitions").add(this.customresourcedefinitions);} else { this.customresourcedefinitions = null; _visitables.get("customresourcedefinitions").remove(this.customresourcedefinitions); } return (A) this;
  }
  public Boolean hasCustomresourcedefinitions() {
    return this.customresourcedefinitions != null;
  }
  public CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitions() {
    return new CSVDescriptionFluentImpl.CustomresourcedefinitionsNestedImpl();
  }
  public CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<A> withNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
    return new CSVDescriptionFluentImpl.CustomresourcedefinitionsNestedImpl(item);
  }
  public CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<A> editCustomresourcedefinitions() {
    return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions());
  }
  public CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitions() {
    return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions() != null ? getCustomresourcedefinitions(): new CustomResourceDefinitionsBuilder().build());
  }
  public CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<A> editOrNewCustomresourcedefinitionsLike(CustomResourceDefinitions item) {
    return withNewCustomresourcedefinitionsLike(getCustomresourcedefinitions() != null ? getCustomresourcedefinitions(): item);
  }
  public String getDescription() {
    return this.description;
  }
  public A withDescription(String description) {
    this.description=description; return (A) this;
  }
  public Boolean hasDescription() {
    return this.description != null;
  }
  public String getDisplayName() {
    return this.displayName;
  }
  public A withDisplayName(String displayName) {
    this.displayName=displayName; return (A) this;
  }
  public Boolean hasDisplayName() {
    return this.displayName != null;
  }
  public A addToIcon(int index,Icon item) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    IconBuilder builder = new IconBuilder(item);
    if (index < 0 || index >= icon.size()) { _visitables.get("icon").add(builder); icon.add(builder); } else { _visitables.get("icon").add(index, builder); icon.add(index, builder);}
    return (A)this;
  }
  public A setToIcon(int index,Icon item) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    IconBuilder builder = new IconBuilder(item);
    if (index < 0 || index >= icon.size()) { _visitables.get("icon").add(builder); icon.add(builder); } else { _visitables.get("icon").set(index, builder); icon.set(index, builder);}
    return (A)this;
  }
  public A addToIcon(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Icon... items) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
  }
  public A addAllToIcon(Collection<Icon> items) {
    if (this.icon == null) {this.icon = new ArrayList<IconBuilder>();}
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").add(builder);this.icon.add(builder);} return (A)this;
  }
  public A removeFromIcon(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Icon... items) {
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder);if (this.icon != null) {this.icon.remove(builder);}} return (A)this;
  }
  public A removeAllFromIcon(Collection<Icon> items) {
    for (Icon item : items) {IconBuilder builder = new IconBuilder(item);_visitables.get("icon").remove(builder);if (this.icon != null) {this.icon.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromIcon(Predicate<IconBuilder> predicate) {
    if (icon == null) return (A) this;
    final Iterator<IconBuilder> each = icon.iterator();
    final List visitables = _visitables.get("icon");
    while (each.hasNext()) {
      IconBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildIcon instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Icon> getIcon() {
    return icon != null ? build(icon) : null;
  }
  public List<Icon> buildIcon() {
    return icon != null ? build(icon) : null;
  }
  public Icon buildIcon(int index) {
    return this.icon.get(index).build();
  }
  public Icon buildFirstIcon() {
    return this.icon.get(0).build();
  }
  public Icon buildLastIcon() {
    return this.icon.get(icon.size() - 1).build();
  }
  public Icon buildMatchingIcon(Predicate<IconBuilder> predicate) {
    for (IconBuilder item: icon) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingIcon(Predicate<IconBuilder> predicate) {
    for (IconBuilder item: icon) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIcon(List<Icon> icon) {
    if (this.icon != null) { _visitables.get("icon").clear();}
    if (icon != null) {this.icon = new ArrayList(); for (Icon item : icon){this.addToIcon(item);}} else { this.icon = null;} return (A) this;
  }
  public A withIcon(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Icon... icon) {
    if (this.icon != null) {this.icon.clear(); _visitables.remove("icon"); }
    if (icon != null) {for (Icon item :icon){ this.addToIcon(item);}} return (A) this;
  }
  public Boolean hasIcon() {
    return icon != null && !icon.isEmpty();
  }
  public A addNewIcon(String base64data,String mediatype) {
    return (A)addToIcon(new Icon(base64data, mediatype));
  }
  public CSVDescriptionFluentImpl.IconNested<A> addNewIcon() {
    return new CSVDescriptionFluentImpl.IconNestedImpl();
  }
  public CSVDescriptionFluentImpl.IconNested<A> addNewIconLike(Icon item) {
    return new CSVDescriptionFluentImpl.IconNestedImpl(-1, item);
  }
  public CSVDescriptionFluentImpl.IconNested<A> setNewIconLike(int index,Icon item) {
    return new CSVDescriptionFluentImpl.IconNestedImpl(index, item);
  }
  public CSVDescriptionFluentImpl.IconNested<A> editIcon(int index) {
    if (icon.size() <= index) throw new RuntimeException("Can't edit icon. Index exceeds size.");
    return setNewIconLike(index, buildIcon(index));
  }
  public CSVDescriptionFluentImpl.IconNested<A> editFirstIcon() {
    if (icon.size() == 0) throw new RuntimeException("Can't edit first icon. The list is empty.");
    return setNewIconLike(0, buildIcon(0));
  }
  public CSVDescriptionFluentImpl.IconNested<A> editLastIcon() {
    int index = icon.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last icon. The list is empty.");
    return setNewIconLike(index, buildIcon(index));
  }
  public CSVDescriptionFluentImpl.IconNested<A> editMatchingIcon(Predicate<IconBuilder> predicate) {
    int index = -1;
    for (int i=0;i<icon.size();i++) { 
    if (predicate.test(icon.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching icon. No match found.");
    return setNewIconLike(index, buildIcon(index));
  }
  public A addToInstallModes(int index,InstallMode item) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    InstallModeBuilder builder = new InstallModeBuilder(item);
    if (index < 0 || index >= installModes.size()) { _visitables.get("installModes").add(builder); installModes.add(builder); } else { _visitables.get("installModes").add(index, builder); installModes.add(index, builder);}
    return (A)this;
  }
  public A setToInstallModes(int index,InstallMode item) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    InstallModeBuilder builder = new InstallModeBuilder(item);
    if (index < 0 || index >= installModes.size()) { _visitables.get("installModes").add(builder); installModes.add(builder); } else { _visitables.get("installModes").set(index, builder); installModes.set(index, builder);}
    return (A)this;
  }
  public A addToInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... items) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
  }
  public A addAllToInstallModes(Collection<InstallMode> items) {
    if (this.installModes == null) {this.installModes = new ArrayList<InstallModeBuilder>();}
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").add(builder);this.installModes.add(builder);} return (A)this;
  }
  public A removeFromInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... items) {
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder);if (this.installModes != null) {this.installModes.remove(builder);}} return (A)this;
  }
  public A removeAllFromInstallModes(Collection<InstallMode> items) {
    for (InstallMode item : items) {InstallModeBuilder builder = new InstallModeBuilder(item);_visitables.get("installModes").remove(builder);if (this.installModes != null) {this.installModes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInstallModes(Predicate<InstallModeBuilder> predicate) {
    if (installModes == null) return (A) this;
    final Iterator<InstallModeBuilder> each = installModes.iterator();
    final List visitables = _visitables.get("installModes");
    while (each.hasNext()) {
      InstallModeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildInstallModes instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<InstallMode> getInstallModes() {
    return installModes != null ? build(installModes) : null;
  }
  public List<InstallMode> buildInstallModes() {
    return installModes != null ? build(installModes) : null;
  }
  public InstallMode buildInstallMode(int index) {
    return this.installModes.get(index).build();
  }
  public InstallMode buildFirstInstallMode() {
    return this.installModes.get(0).build();
  }
  public InstallMode buildLastInstallMode() {
    return this.installModes.get(installModes.size() - 1).build();
  }
  public InstallMode buildMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    for (InstallModeBuilder item: installModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withInstallModes(List<InstallMode> installModes) {
    if (this.installModes != null) { _visitables.get("installModes").clear();}
    if (installModes != null) {this.installModes = new ArrayList(); for (InstallMode item : installModes){this.addToInstallModes(item);}} else { this.installModes = null;} return (A) this;
  }
  public A withInstallModes(io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallMode... installModes) {
    if (this.installModes != null) {this.installModes.clear(); _visitables.remove("installModes"); }
    if (installModes != null) {for (InstallMode item :installModes){ this.addToInstallModes(item);}} return (A) this;
  }
  public Boolean hasInstallModes() {
    return installModes != null && !installModes.isEmpty();
  }
  public A addNewInstallMode(Boolean supported,String type) {
    return (A)addToInstallModes(new InstallMode(supported, type));
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> addNewInstallMode() {
    return new CSVDescriptionFluentImpl.InstallModesNestedImpl();
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> addNewInstallModeLike(InstallMode item) {
    return new CSVDescriptionFluentImpl.InstallModesNestedImpl(-1, item);
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> setNewInstallModeLike(int index,InstallMode item) {
    return new CSVDescriptionFluentImpl.InstallModesNestedImpl(index, item);
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> editInstallMode(int index) {
    if (installModes.size() <= index) throw new RuntimeException("Can't edit installModes. Index exceeds size.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> editFirstInstallMode() {
    if (installModes.size() == 0) throw new RuntimeException("Can't edit first installModes. The list is empty.");
    return setNewInstallModeLike(0, buildInstallMode(0));
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> editLastInstallMode() {
    int index = installModes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last installModes. The list is empty.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public CSVDescriptionFluentImpl.InstallModesNested<A> editMatchingInstallMode(Predicate<InstallModeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<installModes.size();i++) { 
    if (predicate.test(installModes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching installModes. No match found.");
    return setNewInstallModeLike(index, buildInstallMode(index));
  }
  public A addToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.add(index, item);
    return (A)this;
  }
  public A setToKeywords(int index,String item) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    this.keywords.set(index, item); return (A)this;
  }
  public A addToKeywords(java.lang.String... items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A addAllToKeywords(Collection<String> items) {
    if (this.keywords == null) {this.keywords = new ArrayList<String>();}
    for (String item : items) {this.keywords.add(item);} return (A)this;
  }
  public A removeFromKeywords(java.lang.String... items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public A removeAllFromKeywords(Collection<String> items) {
    for (String item : items) {if (this.keywords!= null){ this.keywords.remove(item);}} return (A)this;
  }
  public List<String> getKeywords() {
    return this.keywords;
  }
  public String getKeyword(int index) {
    return this.keywords.get(index);
  }
  public String getFirstKeyword() {
    return this.keywords.get(0);
  }
  public String getLastKeyword() {
    return this.keywords.get(keywords.size() - 1);
  }
  public String getMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingKeyword(Predicate<String> predicate) {
    for (String item: keywords) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKeywords(List<String> keywords) {
    if (keywords != null) {this.keywords = new ArrayList(); for (String item : keywords){this.addToKeywords(item);}} else { this.keywords = null;} return (A) this;
  }
  public A withKeywords(java.lang.String... keywords) {
    if (this.keywords != null) {this.keywords.clear(); _visitables.remove("keywords"); }
    if (keywords != null) {for (String item :keywords){ this.addToKeywords(item);}} return (A) this;
  }
  public Boolean hasKeywords() {
    return keywords != null && !keywords.isEmpty();
  }
  public A addToLinks(int index,AppLink item) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    AppLinkBuilder builder = new AppLinkBuilder(item);
    if (index < 0 || index >= links.size()) { _visitables.get("links").add(builder); links.add(builder); } else { _visitables.get("links").add(index, builder); links.add(index, builder);}
    return (A)this;
  }
  public A setToLinks(int index,AppLink item) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    AppLinkBuilder builder = new AppLinkBuilder(item);
    if (index < 0 || index >= links.size()) { _visitables.get("links").add(builder); links.add(builder); } else { _visitables.get("links").set(index, builder); links.set(index, builder);}
    return (A)this;
  }
  public A addToLinks(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.AppLink... items) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A addAllToLinks(Collection<AppLink> items) {
    if (this.links == null) {this.links = new ArrayList<AppLinkBuilder>();}
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").add(builder);this.links.add(builder);} return (A)this;
  }
  public A removeFromLinks(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.AppLink... items) {
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
  }
  public A removeAllFromLinks(Collection<AppLink> items) {
    for (AppLink item : items) {AppLinkBuilder builder = new AppLinkBuilder(item);_visitables.get("links").remove(builder);if (this.links != null) {this.links.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromLinks(Predicate<AppLinkBuilder> predicate) {
    if (links == null) return (A) this;
    final Iterator<AppLinkBuilder> each = links.iterator();
    final List visitables = _visitables.get("links");
    while (each.hasNext()) {
      AppLinkBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildLinks instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<AppLink> getLinks() {
    return links != null ? build(links) : null;
  }
  public List<AppLink> buildLinks() {
    return links != null ? build(links) : null;
  }
  public AppLink buildLink(int index) {
    return this.links.get(index).build();
  }
  public AppLink buildFirstLink() {
    return this.links.get(0).build();
  }
  public AppLink buildLastLink() {
    return this.links.get(links.size() - 1).build();
  }
  public AppLink buildMatchingLink(Predicate<AppLinkBuilder> predicate) {
    for (AppLinkBuilder item: links) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingLink(Predicate<AppLinkBuilder> predicate) {
    for (AppLinkBuilder item: links) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withLinks(List<AppLink> links) {
    if (this.links != null) { _visitables.get("links").clear();}
    if (links != null) {this.links = new ArrayList(); for (AppLink item : links){this.addToLinks(item);}} else { this.links = null;} return (A) this;
  }
  public A withLinks(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.AppLink... links) {
    if (this.links != null) {this.links.clear(); _visitables.remove("links"); }
    if (links != null) {for (AppLink item :links){ this.addToLinks(item);}} return (A) this;
  }
  public Boolean hasLinks() {
    return links != null && !links.isEmpty();
  }
  public A addNewLink(String name,String url) {
    return (A)addToLinks(new AppLink(name, url));
  }
  public CSVDescriptionFluentImpl.LinksNested<A> addNewLink() {
    return new CSVDescriptionFluentImpl.LinksNestedImpl();
  }
  public CSVDescriptionFluentImpl.LinksNested<A> addNewLinkLike(AppLink item) {
    return new CSVDescriptionFluentImpl.LinksNestedImpl(-1, item);
  }
  public CSVDescriptionFluentImpl.LinksNested<A> setNewLinkLike(int index,AppLink item) {
    return new CSVDescriptionFluentImpl.LinksNestedImpl(index, item);
  }
  public CSVDescriptionFluentImpl.LinksNested<A> editLink(int index) {
    if (links.size() <= index) throw new RuntimeException("Can't edit links. Index exceeds size.");
    return setNewLinkLike(index, buildLink(index));
  }
  public CSVDescriptionFluentImpl.LinksNested<A> editFirstLink() {
    if (links.size() == 0) throw new RuntimeException("Can't edit first links. The list is empty.");
    return setNewLinkLike(0, buildLink(0));
  }
  public CSVDescriptionFluentImpl.LinksNested<A> editLastLink() {
    int index = links.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last links. The list is empty.");
    return setNewLinkLike(index, buildLink(index));
  }
  public CSVDescriptionFluentImpl.LinksNested<A> editMatchingLink(Predicate<AppLinkBuilder> predicate) {
    int index = -1;
    for (int i=0;i<links.size();i++) { 
    if (predicate.test(links.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching links. No match found.");
    return setNewLinkLike(index, buildLink(index));
  }
  public A addToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").add(index, builder); maintainers.add(index, builder);}
    return (A)this;
  }
  public A setToMaintainers(int index,Maintainer item) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    MaintainerBuilder builder = new MaintainerBuilder(item);
    if (index < 0 || index >= maintainers.size()) { _visitables.get("maintainers").add(builder); maintainers.add(builder); } else { _visitables.get("maintainers").set(index, builder); maintainers.set(index, builder);}
    return (A)this;
  }
  public A addToMaintainers(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Maintainer... items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A addAllToMaintainers(Collection<Maintainer> items) {
    if (this.maintainers == null) {this.maintainers = new ArrayList<MaintainerBuilder>();}
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").add(builder);this.maintainers.add(builder);} return (A)this;
  }
  public A removeFromMaintainers(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Maintainer... items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromMaintainers(Collection<Maintainer> items) {
    for (Maintainer item : items) {MaintainerBuilder builder = new MaintainerBuilder(item);_visitables.get("maintainers").remove(builder);if (this.maintainers != null) {this.maintainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMaintainers(Predicate<MaintainerBuilder> predicate) {
    if (maintainers == null) return (A) this;
    final Iterator<MaintainerBuilder> each = maintainers.iterator();
    final List visitables = _visitables.get("maintainers");
    while (each.hasNext()) {
      MaintainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMaintainers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Maintainer> getMaintainers() {
    return maintainers != null ? build(maintainers) : null;
  }
  public List<Maintainer> buildMaintainers() {
    return maintainers != null ? build(maintainers) : null;
  }
  public Maintainer buildMaintainer(int index) {
    return this.maintainers.get(index).build();
  }
  public Maintainer buildFirstMaintainer() {
    return this.maintainers.get(0).build();
  }
  public Maintainer buildLastMaintainer() {
    return this.maintainers.get(maintainers.size() - 1).build();
  }
  public Maintainer buildMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    for (MaintainerBuilder item: maintainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMaintainers(List<Maintainer> maintainers) {
    if (this.maintainers != null) { _visitables.get("maintainers").clear();}
    if (maintainers != null) {this.maintainers = new ArrayList(); for (Maintainer item : maintainers){this.addToMaintainers(item);}} else { this.maintainers = null;} return (A) this;
  }
  public A withMaintainers(io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.Maintainer... maintainers) {
    if (this.maintainers != null) {this.maintainers.clear(); _visitables.remove("maintainers"); }
    if (maintainers != null) {for (Maintainer item :maintainers){ this.addToMaintainers(item);}} return (A) this;
  }
  public Boolean hasMaintainers() {
    return maintainers != null && !maintainers.isEmpty();
  }
  public A addNewMaintainer(String email,String name) {
    return (A)addToMaintainers(new Maintainer(email, name));
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> addNewMaintainer() {
    return new CSVDescriptionFluentImpl.MaintainersNestedImpl();
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> addNewMaintainerLike(Maintainer item) {
    return new CSVDescriptionFluentImpl.MaintainersNestedImpl(-1, item);
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> setNewMaintainerLike(int index,Maintainer item) {
    return new CSVDescriptionFluentImpl.MaintainersNestedImpl(index, item);
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> editMaintainer(int index) {
    if (maintainers.size() <= index) throw new RuntimeException("Can't edit maintainers. Index exceeds size.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> editFirstMaintainer() {
    if (maintainers.size() == 0) throw new RuntimeException("Can't edit first maintainers. The list is empty.");
    return setNewMaintainerLike(0, buildMaintainer(0));
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> editLastMaintainer() {
    int index = maintainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last maintainers. The list is empty.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public CSVDescriptionFluentImpl.MaintainersNested<A> editMatchingMaintainer(Predicate<MaintainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<maintainers.size();i++) { 
    if (predicate.test(maintainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching maintainers. No match found.");
    return setNewMaintainerLike(index, buildMaintainer(index));
  }
  public String getMaturity() {
    return this.maturity;
  }
  public A withMaturity(String maturity) {
    this.maturity=maturity; return (A) this;
  }
  public Boolean hasMaturity() {
    return this.maturity != null;
  }
  public String getMinKubeVersion() {
    return this.minKubeVersion;
  }
  public A withMinKubeVersion(String minKubeVersion) {
    this.minKubeVersion=minKubeVersion; return (A) this;
  }
  public Boolean hasMinKubeVersion() {
    return this.minKubeVersion != null;
  }
  public A addToNativeApis(int index,GroupVersionKind item) {
    if (this.nativeApis == null) {this.nativeApis = new ArrayList<GroupVersionKind>();}
    this.nativeApis.add(index, item);
    return (A)this;
  }
  public A setToNativeApis(int index,GroupVersionKind item) {
    if (this.nativeApis == null) {this.nativeApis = new ArrayList<GroupVersionKind>();}
    this.nativeApis.set(index, item); return (A)this;
  }
  public A addToNativeApis(io.fabric8.kubernetes.api.model.GroupVersionKind... items) {
    if (this.nativeApis == null) {this.nativeApis = new ArrayList<GroupVersionKind>();}
    for (GroupVersionKind item : items) {this.nativeApis.add(item);} return (A)this;
  }
  public A addAllToNativeApis(Collection<GroupVersionKind> items) {
    if (this.nativeApis == null) {this.nativeApis = new ArrayList<GroupVersionKind>();}
    for (GroupVersionKind item : items) {this.nativeApis.add(item);} return (A)this;
  }
  public A removeFromNativeApis(io.fabric8.kubernetes.api.model.GroupVersionKind... items) {
    for (GroupVersionKind item : items) {if (this.nativeApis!= null){ this.nativeApis.remove(item);}} return (A)this;
  }
  public A removeAllFromNativeApis(Collection<GroupVersionKind> items) {
    for (GroupVersionKind item : items) {if (this.nativeApis!= null){ this.nativeApis.remove(item);}} return (A)this;
  }
  public List<GroupVersionKind> getNativeApis() {
    return this.nativeApis;
  }
  public GroupVersionKind getNativeApi(int index) {
    return this.nativeApis.get(index);
  }
  public GroupVersionKind getFirstNativeApi() {
    return this.nativeApis.get(0);
  }
  public GroupVersionKind getLastNativeApi() {
    return this.nativeApis.get(nativeApis.size() - 1);
  }
  public GroupVersionKind getMatchingNativeApi(Predicate<GroupVersionKind> predicate) {
    for (GroupVersionKind item: nativeApis) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNativeApi(Predicate<GroupVersionKind> predicate) {
    for (GroupVersionKind item: nativeApis) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNativeApis(List<GroupVersionKind> nativeApis) {
    if (nativeApis != null) {this.nativeApis = new ArrayList(); for (GroupVersionKind item : nativeApis){this.addToNativeApis(item);}} else { this.nativeApis = null;} return (A) this;
  }
  public A withNativeApis(io.fabric8.kubernetes.api.model.GroupVersionKind... nativeApis) {
    if (this.nativeApis != null) {this.nativeApis.clear(); _visitables.remove("nativeApis"); }
    if (nativeApis != null) {for (GroupVersionKind item :nativeApis){ this.addToNativeApis(item);}} return (A) this;
  }
  public Boolean hasNativeApis() {
    return nativeApis != null && !nativeApis.isEmpty();
  }
  public A addNewNativeApi(String group,String kind,String version) {
    return (A)addToNativeApis(new GroupVersionKind(group, kind, version));
  }
  
  /**
   * This method has been deprecated, please use method buildProvider instead.
   * @return The buildable object.
   */
  @Deprecated
  public AppLink getProvider() {
    return this.provider!=null ?this.provider.build():null;
  }
  public AppLink buildProvider() {
    return this.provider!=null ?this.provider.build():null;
  }
  public A withProvider(AppLink provider) {
    _visitables.get("provider").remove(this.provider);
    if (provider!=null){ this.provider= new AppLinkBuilder(provider); _visitables.get("provider").add(this.provider);} else { this.provider = null; _visitables.get("provider").remove(this.provider); } return (A) this;
  }
  public Boolean hasProvider() {
    return this.provider != null;
  }
  public A withNewProvider(String name,String url) {
    return (A)withProvider(new AppLink(name, url));
  }
  public CSVDescriptionFluentImpl.ProviderNested<A> withNewProvider() {
    return new CSVDescriptionFluentImpl.ProviderNestedImpl();
  }
  public CSVDescriptionFluentImpl.ProviderNested<A> withNewProviderLike(AppLink item) {
    return new CSVDescriptionFluentImpl.ProviderNestedImpl(item);
  }
  public CSVDescriptionFluentImpl.ProviderNested<A> editProvider() {
    return withNewProviderLike(getProvider());
  }
  public CSVDescriptionFluentImpl.ProviderNested<A> editOrNewProvider() {
    return withNewProviderLike(getProvider() != null ? getProvider(): new AppLinkBuilder().build());
  }
  public CSVDescriptionFluentImpl.ProviderNested<A> editOrNewProviderLike(AppLink item) {
    return withNewProviderLike(getProvider() != null ? getProvider(): item);
  }
  public A addToRelatedImages(int index,String item) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<String>();}
    this.relatedImages.add(index, item);
    return (A)this;
  }
  public A setToRelatedImages(int index,String item) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<String>();}
    this.relatedImages.set(index, item); return (A)this;
  }
  public A addToRelatedImages(java.lang.String... items) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<String>();}
    for (String item : items) {this.relatedImages.add(item);} return (A)this;
  }
  public A addAllToRelatedImages(Collection<String> items) {
    if (this.relatedImages == null) {this.relatedImages = new ArrayList<String>();}
    for (String item : items) {this.relatedImages.add(item);} return (A)this;
  }
  public A removeFromRelatedImages(java.lang.String... items) {
    for (String item : items) {if (this.relatedImages!= null){ this.relatedImages.remove(item);}} return (A)this;
  }
  public A removeAllFromRelatedImages(Collection<String> items) {
    for (String item : items) {if (this.relatedImages!= null){ this.relatedImages.remove(item);}} return (A)this;
  }
  public List<String> getRelatedImages() {
    return this.relatedImages;
  }
  public String getRelatedImage(int index) {
    return this.relatedImages.get(index);
  }
  public String getFirstRelatedImage() {
    return this.relatedImages.get(0);
  }
  public String getLastRelatedImage() {
    return this.relatedImages.get(relatedImages.size() - 1);
  }
  public String getMatchingRelatedImage(Predicate<String> predicate) {
    for (String item: relatedImages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingRelatedImage(Predicate<String> predicate) {
    for (String item: relatedImages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRelatedImages(List<String> relatedImages) {
    if (relatedImages != null) {this.relatedImages = new ArrayList(); for (String item : relatedImages){this.addToRelatedImages(item);}} else { this.relatedImages = null;} return (A) this;
  }
  public A withRelatedImages(java.lang.String... relatedImages) {
    if (this.relatedImages != null) {this.relatedImages.clear(); _visitables.remove("relatedImages"); }
    if (relatedImages != null) {for (String item :relatedImages){ this.addToRelatedImages(item);}} return (A) this;
  }
  public Boolean hasRelatedImages() {
    return relatedImages != null && !relatedImages.isEmpty();
  }
  public String getVersion() {
    return this.version;
  }
  public A withVersion(String version) {
    this.version=version; return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CSVDescriptionFluentImpl that = (CSVDescriptionFluentImpl) o;
    if (!java.util.Objects.equals(annotations, that.annotations)) return false;

    if (!java.util.Objects.equals(apiservicedefinitions, that.apiservicedefinitions)) return false;

    if (!java.util.Objects.equals(customresourcedefinitions, that.customresourcedefinitions)) return false;

    if (!java.util.Objects.equals(description, that.description)) return false;

    if (!java.util.Objects.equals(displayName, that.displayName)) return false;

    if (!java.util.Objects.equals(icon, that.icon)) return false;

    if (!java.util.Objects.equals(installModes, that.installModes)) return false;

    if (!java.util.Objects.equals(keywords, that.keywords)) return false;

    if (!java.util.Objects.equals(links, that.links)) return false;

    if (!java.util.Objects.equals(maintainers, that.maintainers)) return false;

    if (!java.util.Objects.equals(maturity, that.maturity)) return false;

    if (!java.util.Objects.equals(minKubeVersion, that.minKubeVersion)) return false;

    if (!java.util.Objects.equals(nativeApis, that.nativeApis)) return false;

    if (!java.util.Objects.equals(provider, that.provider)) return false;

    if (!java.util.Objects.equals(relatedImages, that.relatedImages)) return false;

    if (!java.util.Objects.equals(version, that.version)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(annotations,  apiservicedefinitions,  customresourcedefinitions,  description,  displayName,  icon,  installModes,  keywords,  links,  maintainers,  maturity,  minKubeVersion,  nativeApis,  provider,  relatedImages,  version,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (annotations != null && !annotations.isEmpty()) { sb.append("annotations:"); sb.append(annotations + ","); }
    if (apiservicedefinitions != null) { sb.append("apiservicedefinitions:"); sb.append(apiservicedefinitions + ","); }
    if (customresourcedefinitions != null) { sb.append("customresourcedefinitions:"); sb.append(customresourcedefinitions + ","); }
    if (description != null) { sb.append("description:"); sb.append(description + ","); }
    if (displayName != null) { sb.append("displayName:"); sb.append(displayName + ","); }
    if (icon != null) { sb.append("icon:"); sb.append(icon + ","); }
    if (installModes != null) { sb.append("installModes:"); sb.append(installModes + ","); }
    if (keywords != null && !keywords.isEmpty()) { sb.append("keywords:"); sb.append(keywords + ","); }
    if (links != null) { sb.append("links:"); sb.append(links + ","); }
    if (maintainers != null) { sb.append("maintainers:"); sb.append(maintainers + ","); }
    if (maturity != null) { sb.append("maturity:"); sb.append(maturity + ","); }
    if (minKubeVersion != null) { sb.append("minKubeVersion:"); sb.append(minKubeVersion + ","); }
    if (nativeApis != null && !nativeApis.isEmpty()) { sb.append("nativeApis:"); sb.append(nativeApis + ","); }
    if (provider != null) { sb.append("provider:"); sb.append(provider + ","); }
    if (relatedImages != null && !relatedImages.isEmpty()) { sb.append("relatedImages:"); sb.append(relatedImages + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ApiservicedefinitionsNestedImpl<N> extends APIServiceDefinitionsFluentImpl<CSVDescriptionFluentImpl.ApiservicedefinitionsNested<N>> implements CSVDescriptionFluentImpl.ApiservicedefinitionsNested<N>,Nested<N>{
    ApiservicedefinitionsNestedImpl(APIServiceDefinitions item) {
      this.builder = new APIServiceDefinitionsBuilder(this, item);
    }
    ApiservicedefinitionsNestedImpl() {
      this.builder = new APIServiceDefinitionsBuilder(this);
    }
    APIServiceDefinitionsBuilder builder;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.withApiservicedefinitions(builder.build());
    }
    public N endApiservicedefinitions() {
      return and();
    }
    
  }
  class CustomresourcedefinitionsNestedImpl<N> extends CustomResourceDefinitionsFluentImpl<CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<N>> implements CSVDescriptionFluentImpl.CustomresourcedefinitionsNested<N>,Nested<N>{
    CustomresourcedefinitionsNestedImpl(CustomResourceDefinitions item) {
      this.builder = new CustomResourceDefinitionsBuilder(this, item);
    }
    CustomresourcedefinitionsNestedImpl() {
      this.builder = new CustomResourceDefinitionsBuilder(this);
    }
    CustomResourceDefinitionsBuilder builder;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.withCustomresourcedefinitions(builder.build());
    }
    public N endCustomresourcedefinitions() {
      return and();
    }
    
  }
  class IconNestedImpl<N> extends IconFluentImpl<CSVDescriptionFluentImpl.IconNested<N>> implements CSVDescriptionFluentImpl.IconNested<N>,Nested<N>{
    IconNestedImpl(int index,Icon item) {
      this.index = index;
      this.builder = new IconBuilder(this, item);
    }
    IconNestedImpl() {
      this.index = -1;
      this.builder = new IconBuilder(this);
    }
    IconBuilder builder;
    int index;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.setToIcon(index,builder.build());
    }
    public N endIcon() {
      return and();
    }
    
  }
  class InstallModesNestedImpl<N> extends InstallModeFluentImpl<CSVDescriptionFluentImpl.InstallModesNested<N>> implements CSVDescriptionFluentImpl.InstallModesNested<N>,Nested<N>{
    InstallModesNestedImpl(int index,InstallMode item) {
      this.index = index;
      this.builder = new InstallModeBuilder(this, item);
    }
    InstallModesNestedImpl() {
      this.index = -1;
      this.builder = new InstallModeBuilder(this);
    }
    InstallModeBuilder builder;
    int index;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.setToInstallModes(index,builder.build());
    }
    public N endInstallMode() {
      return and();
    }
    
  }
  class LinksNestedImpl<N> extends AppLinkFluentImpl<CSVDescriptionFluentImpl.LinksNested<N>> implements CSVDescriptionFluentImpl.LinksNested<N>,Nested<N>{
    LinksNestedImpl(int index,AppLink item) {
      this.index = index;
      this.builder = new AppLinkBuilder(this, item);
    }
    LinksNestedImpl() {
      this.index = -1;
      this.builder = new AppLinkBuilder(this);
    }
    AppLinkBuilder builder;
    int index;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.setToLinks(index,builder.build());
    }
    public N endLink() {
      return and();
    }
    
  }
  class MaintainersNestedImpl<N> extends MaintainerFluentImpl<CSVDescriptionFluentImpl.MaintainersNested<N>> implements CSVDescriptionFluentImpl.MaintainersNested<N>,Nested<N>{
    MaintainersNestedImpl(int index,Maintainer item) {
      this.index = index;
      this.builder = new MaintainerBuilder(this, item);
    }
    MaintainersNestedImpl() {
      this.index = -1;
      this.builder = new MaintainerBuilder(this);
    }
    MaintainerBuilder builder;
    int index;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.setToMaintainers(index,builder.build());
    }
    public N endMaintainer() {
      return and();
    }
    
  }
  class ProviderNestedImpl<N> extends AppLinkFluentImpl<CSVDescriptionFluentImpl.ProviderNested<N>> implements CSVDescriptionFluentImpl.ProviderNested<N>,Nested<N>{
    ProviderNestedImpl(AppLink item) {
      this.builder = new AppLinkBuilder(this, item);
    }
    ProviderNestedImpl() {
      this.builder = new AppLinkBuilder(this);
    }
    AppLinkBuilder builder;
    public N and() {
      return (N) CSVDescriptionFluentImpl.this.withProvider(builder.build());
    }
    public N endProvider() {
      return and();
    }
    
  }
  
}