package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OperatorListBuilder extends OperatorListFluentImpl<OperatorListBuilder> implements VisitableBuilder<OperatorList,OperatorListBuilder>{
  public OperatorListBuilder() {
    this(false);
  }
  public OperatorListBuilder(Boolean validationEnabled) {
    this(new OperatorList(), validationEnabled);
  }
  public OperatorListBuilder(OperatorListFluent<?> fluent) {
    this(fluent, false);
  }
  public OperatorListBuilder(OperatorListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OperatorList(), validationEnabled);
  }
  public OperatorListBuilder(OperatorListFluent<?> fluent,OperatorList instance) {
    this(fluent, instance, false);
  }
  public OperatorListBuilder(OperatorListFluent<?> fluent,OperatorList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OperatorListBuilder(OperatorList instance) {
    this(instance,false);
  }
  public OperatorListBuilder(OperatorList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OperatorListFluent<?> fluent;
  Boolean validationEnabled;
  public OperatorList build() {
    OperatorList buildable = new OperatorList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}