package io.fabric8.openshift.api.model.operatorhub.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperatorConditionFluentImpl<A extends OperatorConditionFluent<A>> extends BaseFluent<A> implements OperatorConditionFluent<A>{
  public OperatorConditionFluentImpl() {
  }
  public OperatorConditionFluentImpl(OperatorCondition instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private OperatorConditionSpecBuilder spec;
  private OperatorConditionStatusBuilder status;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public OperatorConditionFluent.MetadataNested<A> withNewMetadata() {
    return new OperatorConditionFluentImpl.MetadataNestedImpl();
  }
  public OperatorConditionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new OperatorConditionFluentImpl.MetadataNestedImpl(item);
  }
  public OperatorConditionFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public OperatorConditionFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public OperatorConditionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public OperatorConditionSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public OperatorConditionSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(OperatorConditionSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new OperatorConditionSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public OperatorConditionFluent.SpecNested<A> withNewSpec() {
    return new OperatorConditionFluentImpl.SpecNestedImpl();
  }
  public OperatorConditionFluent.SpecNested<A> withNewSpecLike(OperatorConditionSpec item) {
    return new OperatorConditionFluentImpl.SpecNestedImpl(item);
  }
  public OperatorConditionFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public OperatorConditionFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new OperatorConditionSpecBuilder().build());
  }
  public OperatorConditionFluent.SpecNested<A> editOrNewSpecLike(OperatorConditionSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public OperatorConditionStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public OperatorConditionStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(OperatorConditionStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new OperatorConditionStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public OperatorConditionFluent.StatusNested<A> withNewStatus() {
    return new OperatorConditionFluentImpl.StatusNestedImpl();
  }
  public OperatorConditionFluent.StatusNested<A> withNewStatusLike(OperatorConditionStatus item) {
    return new OperatorConditionFluentImpl.StatusNestedImpl(item);
  }
  public OperatorConditionFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public OperatorConditionFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new OperatorConditionStatusBuilder().build());
  }
  public OperatorConditionFluent.StatusNested<A> editOrNewStatusLike(OperatorConditionStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OperatorConditionFluentImpl that = (OperatorConditionFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<OperatorConditionFluent.MetadataNested<N>> implements OperatorConditionFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) OperatorConditionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends OperatorConditionSpecFluentImpl<OperatorConditionFluent.SpecNested<N>> implements OperatorConditionFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(OperatorConditionSpec item) {
      this.builder = new OperatorConditionSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new OperatorConditionSpecBuilder(this);
    }
    OperatorConditionSpecBuilder builder;
    public N and() {
      return (N) OperatorConditionFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends OperatorConditionStatusFluentImpl<OperatorConditionFluent.StatusNested<N>> implements OperatorConditionFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(OperatorConditionStatus item) {
      this.builder = new OperatorConditionStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new OperatorConditionStatusBuilder(this);
    }
    OperatorConditionStatusBuilder builder;
    public N and() {
      return (N) OperatorConditionFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}