package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StepResourceBuilder extends StepResourceFluentImpl<StepResourceBuilder> implements VisitableBuilder<StepResource,StepResourceBuilder>{
  public StepResourceBuilder() {
    this(false);
  }
  public StepResourceBuilder(Boolean validationEnabled) {
    this(new StepResource(), validationEnabled);
  }
  public StepResourceBuilder(StepResourceFluent<?> fluent) {
    this(fluent, false);
  }
  public StepResourceBuilder(StepResourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StepResource(), validationEnabled);
  }
  public StepResourceBuilder(StepResourceFluent<?> fluent,StepResource instance) {
    this(fluent, instance, false);
  }
  public StepResourceBuilder(StepResourceFluent<?> fluent,StepResource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroup(instance.getGroup()); 
    fluent.withKind(instance.getKind()); 
    fluent.withManifest(instance.getManifest()); 
    fluent.withName(instance.getName()); 
    fluent.withSourceName(instance.getSourceName()); 
    fluent.withSourceNamespace(instance.getSourceNamespace()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public StepResourceBuilder(StepResource instance) {
    this(instance,false);
  }
  public StepResourceBuilder(StepResource instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withManifest(instance.getManifest()); 
    this.withName(instance.getName()); 
    this.withSourceName(instance.getSourceName()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  StepResourceFluent<?> fluent;
  Boolean validationEnabled;
  public StepResource build() {
    StepResource buildable = new StepResource(fluent.getGroup(),fluent.getKind(),fluent.getManifest(),fluent.getName(),fluent.getSourceName(),fluent.getSourceNamespace(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}