package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CRDDescriptionBuilder extends CRDDescriptionFluentImpl<CRDDescriptionBuilder> implements VisitableBuilder<CRDDescription,CRDDescriptionBuilder>{
  public CRDDescriptionBuilder() {
    this(false);
  }
  public CRDDescriptionBuilder(Boolean validationEnabled) {
    this(new CRDDescription(), validationEnabled);
  }
  public CRDDescriptionBuilder(CRDDescriptionFluent<?> fluent) {
    this(fluent, false);
  }
  public CRDDescriptionBuilder(CRDDescriptionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CRDDescription(), validationEnabled);
  }
  public CRDDescriptionBuilder(CRDDescriptionFluent<?> fluent,CRDDescription instance) {
    this(fluent, instance, false);
  }
  public CRDDescriptionBuilder(CRDDescriptionFluent<?> fluent,CRDDescription instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActionDescriptors(instance.getActionDescriptors()); 
    fluent.withDescription(instance.getDescription()); 
    fluent.withDisplayName(instance.getDisplayName()); 
    fluent.withKind(instance.getKind()); 
    fluent.withName(instance.getName()); 
    fluent.withResources(instance.getResources()); 
    fluent.withSpecDescriptors(instance.getSpecDescriptors()); 
    fluent.withStatusDescriptors(instance.getStatusDescriptors()); 
    fluent.withVersion(instance.getVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CRDDescriptionBuilder(CRDDescription instance) {
    this(instance,false);
  }
  public CRDDescriptionBuilder(CRDDescription instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withActionDescriptors(instance.getActionDescriptors()); 
    this.withDescription(instance.getDescription()); 
    this.withDisplayName(instance.getDisplayName()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withResources(instance.getResources()); 
    this.withSpecDescriptors(instance.getSpecDescriptors()); 
    this.withStatusDescriptors(instance.getStatusDescriptors()); 
    this.withVersion(instance.getVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CRDDescriptionFluent<?> fluent;
  Boolean validationEnabled;
  public CRDDescription build() {
    CRDDescription buildable = new CRDDescription(fluent.getActionDescriptors(),fluent.getDescription(),fluent.getDisplayName(),fluent.getKind(),fluent.getName(),fluent.getResources(),fluent.getSpecDescriptors(),fluent.getStatusDescriptors(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}