package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SubscriptionStatusFluent<A extends SubscriptionStatusFluent<A>> extends BaseFluent<A>{
  public SubscriptionStatusFluent() {
  }
  
  public SubscriptionStatusFluent(SubscriptionStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<SubscriptionCatalogHealthBuilder> catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();
  private ArrayList<SubscriptionConditionBuilder> conditions = new ArrayList<SubscriptionConditionBuilder>();
  private String currentCSV;
  private Integer installPlanGeneration;
  private ObjectReferenceBuilder installPlanRef;
  private String installedCSV;
  private InstallPlanReferenceBuilder installplan;
  private String lastUpdated;
  private String reason;
  private String state;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SubscriptionStatus instance) {
    instance = (instance != null ? instance : new SubscriptionStatus());
    if (instance != null) {
          this.withCatalogHealth(instance.getCatalogHealth());
          this.withConditions(instance.getConditions());
          this.withCurrentCSV(instance.getCurrentCSV());
          this.withInstallPlanGeneration(instance.getInstallPlanGeneration());
          this.withInstallPlanRef(instance.getInstallPlanRef());
          this.withInstalledCSV(instance.getInstalledCSV());
          this.withInstallplan(instance.getInstallplan());
          this.withLastUpdated(instance.getLastUpdated());
          this.withReason(instance.getReason());
          this.withState(instance.getState());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCatalogHealth(int index,SubscriptionCatalogHealth item) {
    if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
    SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
    if (index < 0 || index >= catalogHealth.size()) { _visitables.get("catalogHealth").add(builder); catalogHealth.add(builder); } else { _visitables.get("catalogHealth").add(index, builder); catalogHealth.add(index, builder);}
    return (A)this;
  }
  
  public A setToCatalogHealth(int index,SubscriptionCatalogHealth item) {
    if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
    SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);
    if (index < 0 || index >= catalogHealth.size()) { _visitables.get("catalogHealth").add(builder); catalogHealth.add(builder); } else { _visitables.get("catalogHealth").set(index, builder); catalogHealth.set(index, builder);}
    return (A)this;
  }
  
  public A addToCatalogHealth(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealth... items) {
    if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
    for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").add(builder);this.catalogHealth.add(builder);} return (A)this;
  }
  
  public A addAllToCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
    if (this.catalogHealth == null) {this.catalogHealth = new ArrayList<SubscriptionCatalogHealthBuilder>();}
    for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").add(builder);this.catalogHealth.add(builder);} return (A)this;
  }
  
  public A removeFromCatalogHealth(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealth... items) {
    if (this.catalogHealth == null) return (A)this;
    for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").remove(builder); this.catalogHealth.remove(builder);} return (A)this;
  }
  
  public A removeAllFromCatalogHealth(Collection<SubscriptionCatalogHealth> items) {
    if (this.catalogHealth == null) return (A)this;
    for (SubscriptionCatalogHealth item : items) {SubscriptionCatalogHealthBuilder builder = new SubscriptionCatalogHealthBuilder(item);_visitables.get("catalogHealth").remove(builder); this.catalogHealth.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
    if (catalogHealth == null) return (A) this;
    final Iterator<SubscriptionCatalogHealthBuilder> each = catalogHealth.iterator();
    final List visitables = _visitables.get("catalogHealth");
    while (each.hasNext()) {
      SubscriptionCatalogHealthBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SubscriptionCatalogHealth> buildCatalogHealth() {
    return this.catalogHealth != null ? build(catalogHealth) : null;
  }
  
  public SubscriptionCatalogHealth buildCatalogHealth(int index) {
    return this.catalogHealth.get(index).build();
  }
  
  public SubscriptionCatalogHealth buildFirstCatalogHealth() {
    return this.catalogHealth.get(0).build();
  }
  
  public SubscriptionCatalogHealth buildLastCatalogHealth() {
    return this.catalogHealth.get(catalogHealth.size() - 1).build();
  }
  
  public SubscriptionCatalogHealth buildMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
      for (SubscriptionCatalogHealthBuilder item : catalogHealth) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
      for (SubscriptionCatalogHealthBuilder item : catalogHealth) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCatalogHealth(List<SubscriptionCatalogHealth> catalogHealth) {
    if (this.catalogHealth != null) {
      this._visitables.get("catalogHealth").clear();
    }
    if (catalogHealth != null) {
        this.catalogHealth = new ArrayList();
        for (SubscriptionCatalogHealth item : catalogHealth) {
          this.addToCatalogHealth(item);
        }
    } else {
      this.catalogHealth = null;
    }
    return (A) this;
  }
  
  public A withCatalogHealth(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCatalogHealth... catalogHealth) {
    if (this.catalogHealth != null) {
        this.catalogHealth.clear();
        _visitables.remove("catalogHealth");
    }
    if (catalogHealth != null) {
      for (SubscriptionCatalogHealth item : catalogHealth) {
        this.addToCatalogHealth(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCatalogHealth() {
    return this.catalogHealth != null && !this.catalogHealth.isEmpty();
  }
  
  public CatalogHealthNested<A> addNewCatalogHealth() {
    return new CatalogHealthNested(-1, null);
  }
  
  public CatalogHealthNested<A> addNewCatalogHealthLike(SubscriptionCatalogHealth item) {
    return new CatalogHealthNested(-1, item);
  }
  
  public CatalogHealthNested<A> setNewCatalogHealthLike(int index,SubscriptionCatalogHealth item) {
    return new CatalogHealthNested(index, item);
  }
  
  public CatalogHealthNested<A> editCatalogHealth(int index) {
    if (catalogHealth.size() <= index) throw new RuntimeException("Can't edit catalogHealth. Index exceeds size.");
    return setNewCatalogHealthLike(index, buildCatalogHealth(index));
  }
  
  public CatalogHealthNested<A> editFirstCatalogHealth() {
    if (catalogHealth.size() == 0) throw new RuntimeException("Can't edit first catalogHealth. The list is empty.");
    return setNewCatalogHealthLike(0, buildCatalogHealth(0));
  }
  
  public CatalogHealthNested<A> editLastCatalogHealth() {
    int index = catalogHealth.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last catalogHealth. The list is empty.");
    return setNewCatalogHealthLike(index, buildCatalogHealth(index));
  }
  
  public CatalogHealthNested<A> editMatchingCatalogHealth(Predicate<SubscriptionCatalogHealthBuilder> predicate) {
    int index = -1;
    for (int i=0;i<catalogHealth.size();i++) { 
    if (predicate.test(catalogHealth.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching catalogHealth. No match found.");
    return setNewCatalogHealthLike(index, buildCatalogHealth(index));
  }
  
  public A addToConditions(int index,SubscriptionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
    SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,SubscriptionCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
    SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
    for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<SubscriptionCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<SubscriptionConditionBuilder>();}
    for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCondition... items) {
    if (this.conditions == null) return (A)this;
    for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<SubscriptionCondition> items) {
    if (this.conditions == null) return (A)this;
    for (SubscriptionCondition item : items) {SubscriptionConditionBuilder builder = new SubscriptionConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<SubscriptionConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<SubscriptionConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      SubscriptionConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SubscriptionCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public SubscriptionCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public SubscriptionCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public SubscriptionCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public SubscriptionCondition buildMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
      for (SubscriptionConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
      for (SubscriptionConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<SubscriptionCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (SubscriptionCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.openshift.api.model.operatorhub.v1alpha1.SubscriptionCondition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (SubscriptionCondition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(SubscriptionCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,SubscriptionCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<SubscriptionConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public String getCurrentCSV() {
    return this.currentCSV;
  }
  
  public A withCurrentCSV(String currentCSV) {
    this.currentCSV = currentCSV;
    return (A) this;
  }
  
  public boolean hasCurrentCSV() {
    return this.currentCSV != null;
  }
  
  public Integer getInstallPlanGeneration() {
    return this.installPlanGeneration;
  }
  
  public A withInstallPlanGeneration(Integer installPlanGeneration) {
    this.installPlanGeneration = installPlanGeneration;
    return (A) this;
  }
  
  public boolean hasInstallPlanGeneration() {
    return this.installPlanGeneration != null;
  }
  
  public ObjectReference buildInstallPlanRef() {
    return this.installPlanRef != null ? this.installPlanRef.build() : null;
  }
  
  public A withInstallPlanRef(ObjectReference installPlanRef) {
    this._visitables.remove("installPlanRef");
    if (installPlanRef != null) {
        this.installPlanRef = new ObjectReferenceBuilder(installPlanRef);
        this._visitables.get("installPlanRef").add(this.installPlanRef);
    } else {
        this.installPlanRef = null;
        this._visitables.get("installPlanRef").remove(this.installPlanRef);
    }
    return (A) this;
  }
  
  public boolean hasInstallPlanRef() {
    return this.installPlanRef != null;
  }
  
  public InstallPlanRefNested<A> withNewInstallPlanRef() {
    return new InstallPlanRefNested(null);
  }
  
  public InstallPlanRefNested<A> withNewInstallPlanRefLike(ObjectReference item) {
    return new InstallPlanRefNested(item);
  }
  
  public InstallPlanRefNested<A> editInstallPlanRef() {
    return withNewInstallPlanRefLike(java.util.Optional.ofNullable(buildInstallPlanRef()).orElse(null));
  }
  
  public InstallPlanRefNested<A> editOrNewInstallPlanRef() {
    return withNewInstallPlanRefLike(java.util.Optional.ofNullable(buildInstallPlanRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public InstallPlanRefNested<A> editOrNewInstallPlanRefLike(ObjectReference item) {
    return withNewInstallPlanRefLike(java.util.Optional.ofNullable(buildInstallPlanRef()).orElse(item));
  }
  
  public String getInstalledCSV() {
    return this.installedCSV;
  }
  
  public A withInstalledCSV(String installedCSV) {
    this.installedCSV = installedCSV;
    return (A) this;
  }
  
  public boolean hasInstalledCSV() {
    return this.installedCSV != null;
  }
  
  public InstallPlanReference buildInstallplan() {
    return this.installplan != null ? this.installplan.build() : null;
  }
  
  public A withInstallplan(InstallPlanReference installplan) {
    this._visitables.remove("installplan");
    if (installplan != null) {
        this.installplan = new InstallPlanReferenceBuilder(installplan);
        this._visitables.get("installplan").add(this.installplan);
    } else {
        this.installplan = null;
        this._visitables.get("installplan").remove(this.installplan);
    }
    return (A) this;
  }
  
  public boolean hasInstallplan() {
    return this.installplan != null;
  }
  
  public A withNewInstallplan(String apiVersion,String kind,String name,String uuid) {
    return (A)withInstallplan(new InstallPlanReference(apiVersion, kind, name, uuid));
  }
  
  public InstallplanNested<A> withNewInstallplan() {
    return new InstallplanNested(null);
  }
  
  public InstallplanNested<A> withNewInstallplanLike(InstallPlanReference item) {
    return new InstallplanNested(item);
  }
  
  public InstallplanNested<A> editInstallplan() {
    return withNewInstallplanLike(java.util.Optional.ofNullable(buildInstallplan()).orElse(null));
  }
  
  public InstallplanNested<A> editOrNewInstallplan() {
    return withNewInstallplanLike(java.util.Optional.ofNullable(buildInstallplan()).orElse(new InstallPlanReferenceBuilder().build()));
  }
  
  public InstallplanNested<A> editOrNewInstallplanLike(InstallPlanReference item) {
    return withNewInstallplanLike(java.util.Optional.ofNullable(buildInstallplan()).orElse(item));
  }
  
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
    return (A) this;
  }
  
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  public String getReason() {
    return this.reason;
  }
  
  public A withReason(String reason) {
    this.reason = reason;
    return (A) this;
  }
  
  public boolean hasReason() {
    return this.reason != null;
  }
  
  public String getState() {
    return this.state;
  }
  
  public A withState(String state) {
    this.state = state;
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SubscriptionStatusFluent that = (SubscriptionStatusFluent) o;
    if (!java.util.Objects.equals(catalogHealth, that.catalogHealth)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(currentCSV, that.currentCSV)) return false;
    if (!java.util.Objects.equals(installPlanGeneration, that.installPlanGeneration)) return false;
    if (!java.util.Objects.equals(installPlanRef, that.installPlanRef)) return false;
    if (!java.util.Objects.equals(installedCSV, that.installedCSV)) return false;
    if (!java.util.Objects.equals(installplan, that.installplan)) return false;
    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;
    if (!java.util.Objects.equals(reason, that.reason)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(catalogHealth,  conditions,  currentCSV,  installPlanGeneration,  installPlanRef,  installedCSV,  installplan,  lastUpdated,  reason,  state,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (catalogHealth != null && !catalogHealth.isEmpty()) { sb.append("catalogHealth:"); sb.append(catalogHealth + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentCSV != null) { sb.append("currentCSV:"); sb.append(currentCSV + ","); }
    if (installPlanGeneration != null) { sb.append("installPlanGeneration:"); sb.append(installPlanGeneration + ","); }
    if (installPlanRef != null) { sb.append("installPlanRef:"); sb.append(installPlanRef + ","); }
    if (installedCSV != null) { sb.append("installedCSV:"); sb.append(installedCSV + ","); }
    if (installplan != null) { sb.append("installplan:"); sb.append(installplan + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CatalogHealthNested<N> extends SubscriptionCatalogHealthFluent<CatalogHealthNested<N>> implements Nested<N>{
    CatalogHealthNested(int index,SubscriptionCatalogHealth item) {
      this.index = index;
      this.builder = new SubscriptionCatalogHealthBuilder(this, item);
    }
    SubscriptionCatalogHealthBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionStatusFluent.this.setToCatalogHealth(index,builder.build());
    }
    
    public N endCatalogHealth() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends SubscriptionConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,SubscriptionCondition item) {
      this.index = index;
      this.builder = new SubscriptionConditionBuilder(this, item);
    }
    SubscriptionConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) SubscriptionStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class InstallPlanRefNested<N> extends ObjectReferenceFluent<InstallPlanRefNested<N>> implements Nested<N>{
    InstallPlanRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) SubscriptionStatusFluent.this.withInstallPlanRef(builder.build());
    }
    
    public N endInstallPlanRef() {
      return and();
    }
    
  
  }
  public class InstallplanNested<N> extends InstallPlanReferenceFluent<InstallplanNested<N>> implements Nested<N>{
    InstallplanNested(InstallPlanReference item) {
      this.builder = new InstallPlanReferenceBuilder(this, item);
    }
    InstallPlanReferenceBuilder builder;
    
    public N and() {
      return (N) SubscriptionStatusFluent.this.withInstallplan(builder.build());
    }
    
    public N endInstallplan() {
      return and();
    }
    
  
  }

}