package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceInstanceBuilder extends io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance,io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceBuilder> {

    io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceInstanceBuilder() {
        this(true);
    }

    public ResourceInstanceBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceInstance(), validationEnabled);
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceInstance(), validationEnabled);
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance instance) {
        this(fluent, instance, true);
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstanceFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance instance) {
        this(instance,true);
    }

    public ResourceInstanceBuilder(io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withNamespace(instance.getNamespace()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operatorhub.v1alpha1.ResourceInstance build() {
        ResourceInstance buildable = new ResourceInstance(fluent.getName(),fluent.getNamespace());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceInstanceBuilder that = (ResourceInstanceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
