package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OperatorConditionSpecBuilder extends io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluentImpl<io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec,io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecBuilder> {

    io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public OperatorConditionSpecBuilder() {
        this(true);
    }

    public OperatorConditionSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new OperatorConditionSpec(), validationEnabled);
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new OperatorConditionSpec(), validationEnabled);
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec instance) {
        this(fluent, instance, true);
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpecFluent<?> fluent,io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployments(instance.getDeployments()); 
        fluent.withOverrides(instance.getOverrides()); 
        fluent.withServiceAccounts(instance.getServiceAccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec instance) {
        this(instance,true);
    }

    public OperatorConditionSpecBuilder(io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployments(instance.getDeployments()); 
        this.withOverrides(instance.getOverrides()); 
        this.withServiceAccounts(instance.getServiceAccounts()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.openshift.api.model.operatorhub.v1.OperatorConditionSpec build() {
        OperatorConditionSpec buildable = new OperatorConditionSpec(fluent.getDeployments(),fluent.getOverrides(),fluent.getServiceAccounts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OperatorConditionSpecBuilder that = (OperatorConditionSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
